/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class ArgumentContextUtils {
    private ArgumentContextUtils() {
    }

    static @NonNull ArgumentContextUtils forVersion(YangVersion version) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case YangVersion.VERSION_1 -> RFC6020.INSTANCE;
            case YangVersion.VERSION_1_1 -> RFC7950.INSTANCE;
        };
    }

    static @NonNull ArgumentContextUtils rfc6020() {
        return RFC6020.INSTANCE;
    }

    final @NonNull String stringFromStringContext(IRArgument argument, StatementSourceReference ref) {
        IRArgument iRArgument = argument;
        Objects.requireNonNull(iRArgument);
        IRArgument iRArgument2 = iRArgument;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IRArgument.Concatenation.class, IRArgument.Single.class}, (Object)iRArgument2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IRArgument.Concatenation concat = (IRArgument.Concatenation)iRArgument2;
                yield this.concatStrings(concat.parts(), ref);
            }
            case 1 -> {
                IRArgument.Single single = (IRArgument.Single)iRArgument2;
                String str = single.string();
                if (single.needQuoteCheck()) {
                    this.checkUnquoted(str, ref);
                }
                if (single.needUnescape()) {
                    yield this.unescape(str, ref);
                }
                yield str;
            }
        };
    }

    private @NonNull String concatStrings(List<? extends IRArgument.Single> parts, StatementSourceReference ref) {
        StringBuilder sb = new StringBuilder();
        for (IRArgument.Single single : parts) {
            sb.append(single.needUnescape() ? this.unescape(single.string(), ref) : single.string());
        }
        return sb.toString();
    }

    abstract void checkDoubleQuoted(String var1, StatementSourceReference var2, int var3);

    abstract void checkUnquoted(String var1, StatementSourceReference var2);

    private @NonNull String unescape(String str, StatementSourceReference ref) {
        int backslash = str.indexOf(92);
        return backslash == -1 ? str : this.unescape(ref, str, backslash);
    }

    private @NonNull String unescape(StatementSourceReference ref, String str, int backslash) {
        this.checkDoubleQuoted(str, ref, backslash);
        StringBuilder sb = new StringBuilder(str.length());
        ArgumentContextUtils.unescapeBackslash(sb, str, backslash);
        return sb.toString();
    }

    @VisibleForTesting
    static void unescapeBackslash(StringBuilder sb, String str, int backslash) {
        block2: {
            String substring = str;
            int backslashIndex = backslash;
            while (true) {
                int nextIndex = backslashIndex + 1;
                if (backslashIndex == -1 || nextIndex >= substring.length()) break;
                ArgumentContextUtils.replaceBackslash(sb, substring, nextIndex);
                substring = substring.substring(nextIndex + 1);
                if (substring.length() > 0) {
                    backslashIndex = substring.indexOf(92);
                    continue;
                }
                break block2;
                break;
            }
            sb.append(substring);
        }
    }

    private static void replaceBackslash(StringBuilder sb, String str, int nextAfterBackslash) {
        int backslash = nextAfterBackslash - 1;
        sb.append(str, 0, backslash);
        char c = str.charAt(nextAfterBackslash);
        switch (c) {
            case '\"': 
            case '\\': {
                sb.append(c);
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'n': {
                sb.append('\n');
                break;
            }
            default: {
                sb.append(str, backslash, nextAfterBackslash + 1);
            }
        }
    }

    private static final class RFC6020
    extends ArgumentContextUtils {
        private static final @NonNull RFC6020 INSTANCE = new RFC6020();

        private RFC6020() {
        }

        @Override
        void checkDoubleQuoted(String str, StatementSourceReference ref, int backslash) {
        }

        @Override
        void checkUnquoted(String str, StatementSourceReference ref) {
        }
    }

    private static final class RFC7950
    extends ArgumentContextUtils {
        private static final CharMatcher ANYQUOTE_MATCHER = CharMatcher.anyOf((CharSequence)"'\"");
        private static final @NonNull RFC7950 INSTANCE = new RFC7950();

        private RFC7950() {
        }

        @Override
        void checkDoubleQuoted(String str, StatementSourceReference ref, int backslash) {
            if (backslash < str.length() - 1) {
                int index = backslash;
                while (index != -1) {
                    char escape = str.charAt(index + 1);
                    switch (escape) {
                        case '\"': 
                        case '\\': 
                        case 'n': 
                        case 't': {
                            break;
                        }
                        default: {
                            throw new SourceException(ref, "YANG 1.1: illegal double quoted string (%s). In double quoted string the backslash must be followed by one of the following character [n,t,\",\\], but was '%s'.", new Object[]{str, Character.valueOf(escape)});
                        }
                    }
                    index = str.indexOf(92, index + 2);
                }
            }
        }

        @Override
        void checkUnquoted(String str, StatementSourceReference ref) {
            SourceException.throwIf((boolean)ANYQUOTE_MATCHER.matchesAnyOf((CharSequence)str), (StatementSourceReference)ref, (String)"YANG 1.1: unquoted string (%s) contains illegal characters", (Object[])new Object[]{str});
        }
    }
}

