/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import java.util.Collection;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportedVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

final class RevisionImport {
    private RevisionImport() {
    }

    static void onLinkageDeclared(final StmtContext.Mutable<UnresolvedQName.Unqualified, ImportStatement, ImportEffectiveStatement> stmt) {
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final UnresolvedQName.Unqualified moduleName = (UnresolvedQName.Unqualified)stmt.getArgument();
        Revision revision = (Revision)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), RevisionDateStatement.class);
        final ModelActionBuilder.Prerequisite imported = revision == null ? importAction.requiresCtx(stmt, ParserNamespaces.MODULE, NamespaceKeyCriterion.latestRevisionModule((UnresolvedQName.Unqualified)moduleName), ModelProcessingPhase.SOURCE_LINKAGE) : importAction.requiresCtx(stmt, ParserNamespaces.MODULE, (Object)new SourceIdentifier(moduleName, revision), ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite linkageTarget = importAction.mutatesCtx((StmtContext.Mutable)stmt.getRoot(), ModelProcessingPhase.SOURCE_LINKAGE);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext importedModule = (StmtContext)imported.resolve(ctx);
                SourceIdentifier importedModuleIdentifier = (SourceIdentifier)stmt.namespaceItem(ParserNamespaces.MODULECTX_TO_SOURCE, (Object)importedModule);
                stmt.addToNs(ImportedVersionNamespace.INSTANCE, (Object)Empty.value(), (Object)importedModuleIdentifier);
                QNameModule mod = (QNameModule)InferenceException.throwIfNull((Object)((QNameModule)stmt.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, (Object)importedModule)), (CommonStmtCtx)stmt, (String)"Failed to find module of %s", (Object[])new Object[]{importedModule});
                ((StmtContext.Mutable)linkageTarget.resolve(ctx)).addToNs(ParserNamespaces.IMPORTED_MODULE, (Object)importedModuleIdentifier, (Object)importedModule);
                String impPrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
                stmt.addToNs(ParserNamespaces.IMPORT_PREFIX_TO_MODULECTX, (Object)impPrefix, (Object)importedModule);
                stmt.addToNs(ModuleQNameToPrefix.INSTANCE, (Object)mod, (Object)impPrefix);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (failed.contains(imported)) {
                    throw new InferenceException((CommonStmtCtx)stmt, "Imported module [%s] was not found.", new Object[]{moduleName.getLocalName()});
                }
            }
        });
    }

    static SourceIdentifier getImportedSourceIdentifier(StmtContext<UnresolvedQName.Unqualified, ImportStatement, ?> stmt) {
        StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        return new SourceIdentifier((UnresolvedQName.Unqualified)stmt.getArgument(), revision != null ? (Revision)revision.getArgument() : null);
    }
}

