/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PathEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.path.PathExpressionParser;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class PathStatementSupport
extends AbstractStatementSupport<PathExpression, PathStatement, PathEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.PATH).build();
    private final PathExpressionParser parser;

    private PathStatementSupport(YangParserConfiguration config, PathExpressionParser parser) {
        super((StatementDefinition)YangStmtMapping.PATH, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
        this.parser = Objects.requireNonNull(parser);
    }

    public static PathStatementSupport lenientInstance(YangParserConfiguration config) {
        return new PathStatementSupport(config, new PathExpressionParser.Lenient());
    }

    public static PathStatementSupport strictInstance(YangParserConfiguration config) {
        return new PathStatementSupport(config, new PathExpressionParser());
    }

    public PathExpression parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return this.parser.parseExpression(ctx, value);
    }

    protected PathStatement createDeclared(BoundStmtCtx<PathExpression> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createPath((PathExpression)((PathExpression)ctx.getArgument()), substatements);
    }

    protected PathStatement attachDeclarationReference(PathStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decoratePath((PathStatement)stmt, (DeclarationReference)reference);
    }

    protected PathEffectiveStatement createEffective(EffectiveStmtCtx.Current<PathExpression, PathStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createPath((PathStatement)((PathStatement)stmt.declared()), substatements);
    }
}

