/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi;

import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

public final class ParserNamespaces {
    public static final @NonNull ParserNamespace<QName, StmtContext<QName, ExtensionStatement, ExtensionEffectiveStatement>> EXTENSION = new ParserNamespace("extension");
    public static final @NonNull ParserNamespace<QName, StmtContext<QName, FeatureStatement, FeatureEffectiveStatement>> FEATURE = new ParserNamespace("feature");
    public static final @NonNull ParserNamespace<QName, StmtContext<QName, GroupingStatement, GroupingEffectiveStatement>> GROUPING = new ParserNamespace("grouping");
    public static final @NonNull ParserNamespace<QName, StmtContext<QName, IdentityStatement, IdentityEffectiveStatement>> IDENTITY = new ParserNamespace("identity");
    public static final @NonNull ParserNamespace<SourceIdentifier, StmtContext<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, ModuleStatement, ModuleEffectiveStatement>> MODULE = new ParserNamespace("module");
    public static final @NonNull ParserNamespace<SourceIdentifier, StmtContext<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, SubmoduleStatement, SubmoduleEffectiveStatement>> SUBMODULE = new ParserNamespace("submodule");
    public static final @NonNull ParserNamespace<QName, StmtContext<QName, TypedefStatement, TypedefEffectiveStatement>> TYPE = new ParserNamespace("typedef");
    public static final @NonNull ParserNamespace<QNameModule, StmtContext<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, ModuleStatement, ModuleEffectiveStatement>> NAMESPACE_TO_MODULE = new ParserNamespace("namespace-to-module");
    public static final @NonNull ParserNamespace<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, StmtContext<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, ModuleStatement, ModuleEffectiveStatement>> PRELINKAGE_MODULE = new ParserNamespace("prelinkage-module");
    public static final @NonNull ParserNamespace<String, StmtContext<?, ?, ?>> BELONGSTO_PREFIX_TO_MODULECTX = new ParserNamespace("belongsto-prefix-to-module");
    public static final @NonNull ParserNamespace<String, // Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified> BELONGSTO_PREFIX_TO_MODULE_NAME = new ParserNamespace("belongsto-prefix-to-name");
    public static final @NonNull ParserNamespace<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, StmtContext<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, ModuleStatement, ModuleEffectiveStatement>> MODULE_FOR_BELONGSTO = new ParserNamespace("module-belongsto");
    public static final @NonNull ParserNamespace<String, XMLNamespace> IMP_PREFIX_TO_NAMESPACE = new ParserNamespace("prefix-to-xmlnamespace");
    public static final @NonNull ParserNamespace<String, StmtContext<?, ?, ?>> IMPORT_PREFIX_TO_MODULECTX = new ParserNamespace("import-prefix-to-modulectx");
    public static final @NonNull ParserNamespace<SourceIdentifier, StmtContext<?, ?, ?>> IMPORTED_MODULE = new ParserNamespace("imported-module");
    public static final @NonNull ParserNamespace<SourceIdentifier, StmtContext<?, ?, ?>> INCLUDED_MODULE = new ParserNamespace("included-module");
    public static final @NonNull ParserNamespace<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, StmtContext<?, ?, ?>> INCLUDED_SUBMODULE_NAME_TO_MODULECTX = new ParserNamespace("included-submodule-to-modulectx");
    public static final @NonNull ParserNamespace<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, QNameModule> MODULE_NAME_TO_QNAME = new ParserNamespace("module-name-to-qnamemodule");
    public static final @NonNull ParserNamespace<StmtContext<?, ?, ?>, QNameModule> MODULECTX_TO_QNAME = new ParserNamespace("modulectx-to-qnamemodule");
    public static final @NonNull ParserNamespace<Empty, FeatureSet> SUPPORTED_FEATURES = new ParserNamespace("supportedFeatures");
    public static final @NonNull ParserNamespace<String, QNameModule> PREFIX_TO_MODULE = new ParserNamespace("prefix-to-qnamemodule");
    public static final @NonNull ParserNamespace<Empty, SetMultimap<QNameModule, QNameModule>> MODULES_DEVIATED_BY = new ParserNamespace("moduleDeviations");
    public static final @NonNull ParserNamespace<QNameModule, // Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified> MODULE_NAMESPACE_TO_NAME = new ParserNamespace("qnamemodule-to-name");
    public static final @NonNull ParserNamespace<// Could not load outer class - annotation placement on inner may be incorrect
    UnresolvedQName.Unqualified, XMLNamespace> MODULE_NAME_TO_NAMESPACE = new ParserNamespace("module-name-to-xmlnamespace");
    public static final @NonNull ParserNamespace<StmtContext<?, ?, ?>, SourceIdentifier> MODULECTX_TO_SOURCE = new ParserNamespace("modulectx-to-source");
    private static final @NonNull ParserNamespace<?, ?> SCHEMA_TREE = new ParserNamespace("schemaTree");

    public static <D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>> @NonNull ParserNamespace<QName, StmtContext<QName, D, E>> schemaTree() {
        return SCHEMA_TREE;
    }

    private ParserNamespaces() {
    }

    public static Optional<StmtContext<?, ?, ?>> findSchemaTreeStatement(StmtContext<?, ?, ?> root, SchemaNodeIdentifier identifier) {
        Iterator iterator = identifier.getNodeIdentifiers().iterator();
        if (!iterator.hasNext()) {
            return Optional.of(root);
        }
        QName nextPath = (QName)iterator.next();
        StmtContext current = root.namespaceItem(ParserNamespaces.schemaTree(), nextPath);
        if (current == null) {
            return Optional.ofNullable(ParserNamespaces.tryToFindUnknownStatement(nextPath.getLocalName(), root));
        }
        while (current != null && iterator.hasNext()) {
            nextPath = (QName)iterator.next();
            StmtContext nextNodeCtx = current.namespaceItem(ParserNamespaces.schemaTree(), nextPath);
            if (nextNodeCtx == null) {
                return Optional.ofNullable(ParserNamespaces.tryToFindUnknownStatement(nextPath.getLocalName(), current));
            }
            current = nextNodeCtx;
        }
        return Optional.ofNullable(current);
    }

    private static StmtContext<?, ?, ?> tryToFindUnknownStatement(String localName, StmtContext<?, ?, ?> current) {
        Collection unknownSubstatements = StmtContextUtils.findAllSubstatements(current, UnknownStatement.class);
        for (StmtContext unknownSubstatement : unknownSubstatements) {
            if (!localName.equals(unknownSubstatement.rawArgument())) continue;
            return unknownSubstatement;
        }
        return null;
    }
}

