/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatementSupportBundle
implements Immutable {
    private static final StatementSupportBundle EMPTY = new StatementSupportBundle(null, null, ImmutableMap.of(), ImmutableMap.of(), ImmutableTable.of());
    private final StatementSupportBundle parent;
    private final ImmutableMap<QName, StatementSupport<?, ?, ?>> commonDefinitions;
    private final ImmutableTable<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificDefinitions;
    private final ImmutableMap<ParserNamespace<?, ?>, NamespaceBehaviour<?, ?>> namespaceDefinitions;
    private final ImmutableSet<YangVersion> supportedVersions;

    private StatementSupportBundle(StatementSupportBundle parent, ImmutableSet<YangVersion> supportedVersions, ImmutableMap<QName, StatementSupport<?, ?, ?>> commonDefinitions, ImmutableMap<ParserNamespace<?, ?>, NamespaceBehaviour<?, ?>> namespaceDefinitions, ImmutableTable<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificDefinitions) {
        this.parent = parent;
        this.supportedVersions = supportedVersions;
        this.commonDefinitions = Objects.requireNonNull(commonDefinitions);
        this.namespaceDefinitions = Objects.requireNonNull(namespaceDefinitions);
        this.versionSpecificDefinitions = Objects.requireNonNull(versionSpecificDefinitions);
    }

    public ImmutableMap<QName, StatementSupport<?, ?, ?>> getCommonDefinitions() {
        return this.commonDefinitions;
    }

    public ImmutableMap<QName, StatementSupport<?, ?, ?>> getDefinitionsSpecificForVersion(YangVersion version) {
        return this.versionSpecificDefinitions.row((Object)version);
    }

    public ImmutableTable<YangVersion, QName, StatementSupport<?, ?, ?>> getAllVersionSpecificDefinitions() {
        return this.versionSpecificDefinitions;
    }

    public ImmutableMap<ParserNamespace<?, ?>, NamespaceBehaviour<?, ?>> getNamespaceDefinitions() {
        return this.namespaceDefinitions;
    }

    public static Builder builder(Set<YangVersion> supportedVersions) {
        return new Builder(supportedVersions, EMPTY);
    }

    public static Builder derivedFrom(StatementSupportBundle parent) {
        return new Builder(parent.getSupportedVersions(), parent);
    }

    public Set<YangVersion> getSupportedVersions() {
        return this.supportedVersions;
    }

    public <K, V> @Nullable NamespaceBehaviour<K, V> namespaceBehaviourOf(ParserNamespace<K, V> namespace) {
        NamespaceBehaviour potential = (NamespaceBehaviour)this.namespaceDefinitions.get(namespace);
        if (potential == null) {
            return this.parent == null ? null : this.parent.namespaceBehaviourOf(namespace);
        }
        Preconditions.checkState((boolean)namespace.equals(potential.namespace()));
        NamespaceBehaviour ret = potential;
        return ret;
    }

    public boolean hasNamespaceBehaviour(ParserNamespace<?, ?> namespace) {
        if (this.namespaceDefinitions.containsKey(namespace)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasNamespaceBehaviour(namespace);
        }
        return false;
    }

    public StatementSupport<?, ?, ?> getStatementDefinition(YangVersion version, QName stmtName) {
        StatementSupport<?, ?, ?> result = this.getVersionSpecificStatementDefinition(version, stmtName);
        if (result == null) {
            result = this.getCommonStatementDefinition(stmtName);
        }
        return result;
    }

    private StatementSupport<?, ?, ?> getCommonStatementDefinition(QName stmtName) {
        StatementSupport potential = (StatementSupport)this.commonDefinitions.get((Object)stmtName);
        if (potential != null) {
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getCommonStatementDefinition(stmtName);
        }
        return null;
    }

    private StatementSupport<?, ?, ?> getVersionSpecificStatementDefinition(YangVersion version, QName stmtName) {
        StatementSupport potential = (StatementSupport)this.versionSpecificDefinitions.get((Object)version, (Object)stmtName);
        if (potential != null) {
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getVersionSpecificStatementDefinition(version, stmtName);
        }
        return null;
    }

    public static final class Builder
    implements Mutable {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private final Map<QName, StatementSupport<?, ?, ?>> commonStatements = new HashMap();
        private final Table<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificStatements = HashBasedTable.create();
        private final Map<ParserNamespace<?, ?>, NamespaceBehaviour<?, ?>> namespaces = new HashMap();
        private final ImmutableSet<YangVersion> supportedVersions;
        private StatementSupportBundle parent;

        Builder(Set<YangVersion> supportedVersions, StatementSupportBundle parent) {
            this.parent = Objects.requireNonNull(parent);
            this.supportedVersions = ImmutableSet.copyOf(supportedVersions);
        }

        public @NonNull Builder addSupport(StatementSupport<?, ?, ?> support) {
            QName identifier = support.statementName();
            this.checkNoParentDefinition(identifier);
            Preconditions.checkState((!this.commonStatements.containsKey(identifier) ? 1 : 0) != 0, (String)"Statement %s already defined in common statement bundle.", (Object)identifier);
            this.commonStatements.put(identifier, support);
            return this;
        }

        public @NonNull Builder addSupport(NamespaceBehaviour<?, ?> namespaceSupport) {
            ParserNamespace<?, ?> namespace = namespaceSupport.namespace();
            Preconditions.checkState((!this.namespaces.containsKey(namespace) ? 1 : 0) != 0);
            Preconditions.checkState((!this.parent.hasNamespaceBehaviour(namespace) ? 1 : 0) != 0);
            this.namespaces.put(namespace, namespaceSupport);
            return this;
        }

        public @NonNull Builder addVersionSpecificSupport(YangVersion version, StatementSupport<?, ?, ?> support) {
            Preconditions.checkArgument((boolean)this.supportedVersions.contains((Object)Objects.requireNonNull(version)));
            QName identifier = support.statementName();
            Preconditions.checkState((!this.commonStatements.containsKey(identifier) ? 1 : 0) != 0, (String)"Statement %s already defined in common statement bundle.", (Object)identifier);
            Preconditions.checkState((!this.versionSpecificStatements.contains((Object)version, (Object)identifier) ? 1 : 0) != 0, (String)"Statement %s already defined for version %s.", (Object)identifier, (Object)version);
            this.checkNoParentDefinition(identifier);
            Preconditions.checkState((this.parent.getVersionSpecificStatementDefinition(version, identifier) == null ? 1 : 0) != 0, (String)"Statement %s already defined for version %s in parent's statement bundle.", (Object)identifier, (Object)version);
            this.versionSpecificStatements.put((Object)version, (Object)identifier, support);
            return this;
        }

        public Set<YangVersion> getSupportedVersions() {
            return this.supportedVersions;
        }

        public @NonNull Builder setParent(StatementSupportBundle parent) {
            this.parent = parent;
            return this;
        }

        public @NonNull Builder overrideSupport(StatementSupport<?, ?, ?> support) {
            QName identifier = support.statementName();
            this.checkNoParentDefinition(identifier);
            StatementSupport<?, ?, ?> previousSupport = this.commonStatements.replace(identifier, support);
            Preconditions.checkState((previousSupport != null ? 1 : 0) != 0, (String)"Statement %s was not previously defined", (Object)identifier);
            LOG.debug("Changed statement {} support from {} to {}", new Object[]{identifier, previousSupport, support});
            return this;
        }

        public @NonNull StatementSupportBundle build() {
            Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"Parent must not be null");
            return new StatementSupportBundle(this.parent, this.supportedVersions, ImmutableMap.copyOf(this.commonStatements), ImmutableMap.copyOf(this.namespaces), ImmutableTable.copyOf(this.versionSpecificStatements));
        }

        private void checkNoParentDefinition(QName identifier) {
            Preconditions.checkState((this.parent.getCommonStatementDefinition(identifier) == null ? 1 : 0) != 0, (String)"Statement %s is defined in parent's common statement bundle", (Object)identifier);
        }
    }
}

