/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.test.util;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;

@Beta
public final class YangParserTestUtils {
    private static final FileFilter YANG_FILE_FILTER = file -> {
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        return name.endsWith(".yang") && file.isFile();
    };
    private static final @NonNull YangParserFactory PARSER_FACTORY;

    private YangParserTestUtils() {
    }

    public static EffectiveModelContext parseYangResource(String resource) {
        return YangParserTestUtils.parseYangResource(resource, YangParserConfiguration.DEFAULT);
    }

    public static EffectiveModelContext parseYangResource(String resource, YangParserConfiguration config) {
        return YangParserTestUtils.parseYangResource(resource, config, null);
    }

    public static EffectiveModelContext parseYangResource(String resource, Set<QName> supportedFeatures) {
        return YangParserTestUtils.parseYangResource(resource, YangParserConfiguration.DEFAULT, supportedFeatures);
    }

    public static EffectiveModelContext parseYangResource(String resource, YangParserConfiguration config, Set<QName> supportedFeatures) {
        YangTextSchemaSource source = YangTextSchemaSource.forResource(YangParserTestUtils.class, (String)resource);
        return YangParserTestUtils.parseYangSources(config, supportedFeatures, source);
    }

    public static EffectiveModelContext parseYangFiles(File ... files) {
        return YangParserTestUtils.parseYangFiles(Arrays.asList(files));
    }

    public static EffectiveModelContext parseYangFiles(Collection<File> files) {
        return YangParserTestUtils.parseYangFiles(YangParserConfiguration.DEFAULT, files);
    }

    public static EffectiveModelContext parseYangFiles(Set<QName> supportedFeatures, File ... files) {
        return YangParserTestUtils.parseYangFiles(supportedFeatures, Arrays.asList(files));
    }

    public static EffectiveModelContext parseYangFiles(Set<QName> supportedFeatures, Collection<File> files) {
        return YangParserTestUtils.parseYangFiles(supportedFeatures, YangParserConfiguration.DEFAULT, files);
    }

    public static EffectiveModelContext parseYangFiles(YangParserConfiguration config, File ... files) {
        return YangParserTestUtils.parseYangFiles(config, Arrays.asList(files));
    }

    public static EffectiveModelContext parseYangFiles(YangParserConfiguration config, Collection<File> files) {
        return YangParserTestUtils.parseYangFiles(null, config, files);
    }

    public static EffectiveModelContext parseYangFiles(Set<QName> supportedFeatures, YangParserConfiguration config, File ... files) {
        return YangParserTestUtils.parseYangFiles(supportedFeatures, config, Arrays.asList(files));
    }

    public static EffectiveModelContext parseYangFiles(Set<QName> supportedFeatures, YangParserConfiguration config, Collection<File> files) {
        return YangParserTestUtils.parseSources(config, supportedFeatures, files.stream().map(file -> YangTextSchemaSource.forPath((Path)file.toPath())).collect(Collectors.toList()));
    }

    public static EffectiveModelContext parseYangResourceDirectory(String resourcePath) {
        return YangParserTestUtils.parseYangResourceDirectory(resourcePath, YangParserConfiguration.DEFAULT);
    }

    public static EffectiveModelContext parseYangResourceDirectory(String resourcePath, YangParserConfiguration config) {
        return YangParserTestUtils.parseYangResourceDirectory(resourcePath, null, config);
    }

    public static EffectiveModelContext parseYangResourceDirectory(String resourcePath, Set<QName> supportedFeatures) {
        return YangParserTestUtils.parseYangResourceDirectory(resourcePath, supportedFeatures, YangParserConfiguration.DEFAULT);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Wrong inferent on listFiles")
    public static EffectiveModelContext parseYangResourceDirectory(String resourcePath, Set<QName> supportedFeatures, YangParserConfiguration config) {
        URI directoryPath;
        try {
            directoryPath = YangParserTestUtils.class.getResource(resourcePath).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to open resource " + resourcePath, e);
        }
        return YangParserTestUtils.parseYangFiles(supportedFeatures, config, new File(directoryPath).listFiles(YANG_FILE_FILTER));
    }

    public static EffectiveModelContext parseYangResources(Class<?> clazz, String ... resources) {
        return YangParserTestUtils.parseYangResources(clazz, Arrays.asList(resources));
    }

    public static EffectiveModelContext parseYangResources(Class<?> clazz, Collection<String> resources) {
        ArrayList<YangTextSchemaSource> sources = new ArrayList<YangTextSchemaSource>(resources.size());
        for (String r : resources) {
            sources.add(YangTextSchemaSource.forResource(clazz, (String)r));
        }
        return YangParserTestUtils.parseSources(YangParserConfiguration.DEFAULT, null, sources);
    }

    public static EffectiveModelContext parseYangResources(List<String> yangDirs, List<String> yangFiles, Set<QName> supportedFeatures) {
        return YangParserTestUtils.parseYangResources(yangDirs, yangFiles, supportedFeatures, YangParserConfiguration.DEFAULT);
    }

    public static EffectiveModelContext parseYangResources(List<String> yangResourceDirs, List<String> yangResources, YangParserConfiguration config) {
        return YangParserTestUtils.parseYangResources(yangResourceDirs, yangResources, null, config);
    }

    public static EffectiveModelContext parseYangResources(List<String> yangResourceDirs, List<String> yangResources, Set<QName> supportedFeatures, YangParserConfiguration config) {
        ArrayList<File> allYangFiles = new ArrayList<File>();
        for (String yangDir : yangResourceDirs) {
            allYangFiles.addAll(YangParserTestUtils.getYangFiles(yangDir));
        }
        for (String yangFile : yangResources) {
            try {
                allYangFiles.add(new File(YangParserTestUtils.class.getResource(yangFile).toURI()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid resource " + yangFile, e);
            }
        }
        return YangParserTestUtils.parseYangFiles(supportedFeatures, config, allYangFiles);
    }

    public static EffectiveModelContext parseYangSources(YangParserConfiguration config, Set<QName> supportedFeatures, YangTextSchemaSource ... sources) {
        return YangParserTestUtils.parseSources(config, supportedFeatures, Arrays.asList(sources));
    }

    public static EffectiveModelContext parseSources(YangParserConfiguration config, Set<QName> supportedFeatures, Collection<? extends SchemaSourceRepresentation> sources) {
        YangParser parser = PARSER_FACTORY.createParser(config);
        if (supportedFeatures != null) {
            parser.setSupportedFeatures(supportedFeatures);
        }
        try {
            parser.addSources(sources);
        }
        catch (YangSyntaxErrorException e) {
            throw new IllegalArgumentException("Malformed source", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read a source", e);
        }
        try {
            return parser.buildEffectiveModel();
        }
        catch (YangParserException e) {
            throw new IllegalStateException("Failed to assemble SchemaContext", e);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Wrong inferent on listFiles")
    private static Collection<File> getYangFiles(String resourcePath) {
        URI directoryPath;
        try {
            directoryPath = YangParserTestUtils.class.getResource(resourcePath).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to open resource directory " + resourcePath, e);
        }
        return Arrays.asList(new File(directoryPath).listFiles(YANG_FILE_FILTER));
    }

    static {
        Iterator<@NonNull YangParserFactory> it = ServiceLoader.load(YangParserFactory.class).iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("No YangParserFactory found");
        }
        PARSER_FACTORY = it.next();
    }
}

