/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.xpath.api.DoubleXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;

final class DoubleNumberExpr
extends YangNumberExpr {
    private static final long serialVersionUID = 1L;
    private final double value;

    private DoubleNumberExpr(double value) {
        this.value = value;
    }

    static DoubleNumberExpr of(double value) {
        return new DoubleNumberExpr(value);
    }

    double getValue() {
        return this.value;
    }

    @Override
    public Double getNumber() {
        return this.value;
    }

    @Override
    public DoubleXPathMathSupport getSupport() {
        return DoubleXPathMathSupport.INSTANCE;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DoubleNumberExpr)) return false;
        DoubleNumberExpr other = (DoubleNumberExpr)obj;
        if (!this.bitEqual(other.value)) return false;
        return true;
    }

    private boolean bitEqual(double other) {
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

