/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.xpath.antlr.instanceIdentifierLexer;
import org.opendaylight.yangtools.yang.xpath.antlr.instanceIdentifierParser;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathMode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.impl.CapturingErrorListener;
import org.opendaylight.yangtools.yang.xpath.impl.FunctionSupport;
import org.opendaylight.yangtools.yang.xpath.impl.ParseTreeUtils;

abstract class InstanceIdentifierParser {
    private final YangXPathMathSupport mathSupport;

    InstanceIdentifierParser(YangXPathMathMode mathMode) {
        this.mathSupport = mathMode.getSupport();
    }

    final YangLocationPath.Absolute interpretAsInstanceIdentifier(YangLiteralExpr expr) throws XPathExpressionException {
        instanceIdentifierLexer lexer = new instanceIdentifierLexer((CharStream)CharStreams.fromString((String)expr.getLiteral()));
        instanceIdentifierParser parser = new instanceIdentifierParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        CapturingErrorListener listener = new CapturingErrorListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        instanceIdentifierParser.InstanceIdentifierContext id = parser.instanceIdentifier();
        listener.reportError();
        int length = id.getChildCount();
        ArrayList<YangLocationPath.QNameStep> steps = new ArrayList<YangLocationPath.QNameStep>(length / 2);
        for (int i = 1; i < length; i += 2) {
            steps.add(this.parsePathArgument(ParseTreeUtils.getChild((ParseTree)id, instanceIdentifierParser.PathArgumentContext.class, i)));
        }
        return YangLocationPath.absolute(steps);
    }

    abstract YangQNameExpr createExpr(String var1);

    abstract YangQNameExpr createExpr(String var1, String var2);

    abstract YangLocationPath.QNameStep createChildStep(String var1, Collection<YangExpr> var2);

    abstract YangLocationPath.QNameStep createChildStep(String var1, String var2, Collection<YangExpr> var3);

    private YangLocationPath.QNameStep parsePathArgument(instanceIdentifierParser.PathArgumentContext expr) {
        ImmutableSet predicates = switch (expr.getChildCount()) {
            case 1 -> ImmutableSet.of();
            case 2 -> this.parsePredicate(ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.PredicateContext.class, 1));
            default -> throw ParseTreeUtils.illegalShape((ParseTree)expr);
        };
        instanceIdentifierParser.NodeIdentifierContext childExpr = ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.NodeIdentifierContext.class, 0);
        String first = InstanceIdentifierParser.verifyIdentifier(childExpr, 0);
        return switch (childExpr.getChildCount()) {
            case 1 -> this.createChildStep(first, (Collection<YangExpr>)predicates);
            case 3 -> this.createChildStep(first, InstanceIdentifierParser.verifyIdentifier(childExpr, 2), (Collection<YangExpr>)predicates);
            default -> throw ParseTreeUtils.illegalShape((ParseTree)childExpr);
        };
    }

    private Collection<YangExpr> parsePredicate(instanceIdentifierParser.PredicateContext expr) {
        ParseTree parseTree = expr.getChild(0);
        Objects.requireNonNull(parseTree);
        ParseTree parseTree2 = parseTree;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{instanceIdentifierParser.LeafListPredicateContext.class, instanceIdentifierParser.PosContext.class}, (Object)parseTree2, n)) {
            case 0 -> {
                instanceIdentifierParser.LeafListPredicateContext llp = (instanceIdentifierParser.LeafListPredicateContext)parseTree2;
                yield ImmutableSet.of((Object)YangBinaryOperator.EQUALS.exprWith((YangExpr)YangLocationPath.self(), (YangExpr)InstanceIdentifierParser.parseEqStringValue(ParseTreeUtils.getChild(llp.getChild(instanceIdentifierParser.LeafListPredicateExprContext.class, 0), instanceIdentifierParser.EqQuotedStringContext.class, 1))));
            }
            case 1 -> {
                instanceIdentifierParser.PosContext pc = (instanceIdentifierParser.PosContext)parseTree2;
                yield ImmutableSet.of((Object)YangBinaryOperator.EQUALS.exprWith((YangExpr)FunctionSupport.POSITION, (YangExpr)this.mathSupport.createNumber(pc.getToken(8, 0).getText())));
            }
            default -> {
                int length = expr.getChildCount();
                ImmutableSet ret = new ArrayList(length);
                for (int i = 0; i < length; ++i) {
                    instanceIdentifierParser.KeyPredicateExprContext pred = (instanceIdentifierParser.KeyPredicateExprContext)ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.KeyPredicateContext.class, i).getChild(instanceIdentifierParser.KeyPredicateExprContext.class, 0);
                    ret.add(YangBinaryOperator.EQUALS.exprWith((YangExpr)this.createChildExpr(ParseTreeUtils.getChild((ParseTree)pred, instanceIdentifierParser.NodeIdentifierContext.class, 0)), (YangExpr)InstanceIdentifierParser.parseEqStringValue(ParseTreeUtils.getChild((ParseTree)pred, instanceIdentifierParser.EqQuotedStringContext.class, 1))));
                }
                yield ret;
            }
        };
    }

    private YangQNameExpr createChildExpr(instanceIdentifierParser.NodeIdentifierContext expr) {
        String first = InstanceIdentifierParser.verifyIdentifier(expr, 0);
        return switch (expr.getChildCount()) {
            case 1 -> this.createExpr(first);
            case 3 -> this.createExpr(first, InstanceIdentifierParser.verifyIdentifier(expr, 2));
            default -> throw ParseTreeUtils.illegalShape((ParseTree)expr);
        };
    }

    private static String verifyIdentifier(instanceIdentifierParser.NodeIdentifierContext expr, int child) {
        return ParseTreeUtils.verifyToken((ParseTree)expr, child, 7).getText();
    }

    private static YangLiteralExpr parseEqStringValue(instanceIdentifierParser.EqQuotedStringContext expr) {
        instanceIdentifierParser.QuotedStringContext quotedString = ParseTreeUtils.getChild((ParseTree)expr, instanceIdentifierParser.QuotedStringContext.class, expr.getChildCount() - 1);
        return switch (quotedString.getChildCount()) {
            case 1 -> YangLiteralExpr.empty();
            case 2 -> {
                TerminalNode terminal = ParseTreeUtils.verifyTerminal(quotedString.getChild(0));
                Token token = terminal.getSymbol();
                String v1 = switch (token.getType()) {
                    case 12 -> InstanceIdentifierParser.unescape(token.getText());
                    case 14 -> token.getText();
                    default -> throw ParseTreeUtils.illegalShape((ParseTree)terminal);
                };
                String literal = v1;
                yield YangLiteralExpr.of((String)literal);
            }
            default -> throw ParseTreeUtils.illegalShape((ParseTree)quotedString);
        };
    }

    private static String unescape(String escaped) {
        int firstEscape = escaped.indexOf(92);
        return firstEscape == -1 ? escaped : InstanceIdentifierParser.unescape(escaped, firstEscape);
    }

    private static String unescape(String escaped, int firstEscape) {
        int length = escaped.length();
        StringBuilder sb = new StringBuilder(length - 1).append(escaped, 0, firstEscape);
        int esc = firstEscape;
        while (true) {
            char ch = escaped.charAt(esc + 1);
            sb.append(switch (ch) {
                case 'n' -> '\n';
                case 't' -> '\t';
                case '\"' -> '\"';
                case '\\' -> '\\';
                default -> throw new VerifyException("Unexpected escaped char '" + ch + "'");
            });
            int start = esc + 2;
            esc = escaped.indexOf(92, start);
            if (esc == -1) {
                return sb.append(escaped, start, length).toString();
            }
            sb.append(escaped, start, esc);
        }
    }

    static final class Qualified
    extends InstanceIdentifierParser {
        private final YangNamespaceContext namespaceContext;

        Qualified(YangXPathMathMode mathMode, YangNamespaceContext namespaceContext) {
            super(mathMode);
            this.namespaceContext = Objects.requireNonNull(namespaceContext);
        }

        @Override
        YangQNameExpr createExpr(String localName) {
            return YangQNameExpr.of((UnresolvedQName)UnresolvedQName.Unqualified.of((String)localName));
        }

        @Override
        YangQNameExpr createExpr(String prefix, String localName) {
            return YangQNameExpr.of((QName)this.namespaceContext.createQName(prefix, localName));
        }

        @Override
        YangLocationPath.QNameStep createChildStep(String localName, Collection<YangExpr> predicates) {
            return YangXPathAxis.CHILD.asStep((UnresolvedQName)UnresolvedQName.Unqualified.of((String)localName), predicates);
        }

        @Override
        YangLocationPath.QNameStep createChildStep(String prefix, String localName, Collection<YangExpr> predicates) {
            return YangXPathAxis.CHILD.asStep(this.namespaceContext.createQName(prefix, localName), predicates);
        }
    }

    static final class Base
    extends InstanceIdentifierParser {
        Base(YangXPathMathMode mathMode) {
            super(mathMode);
        }

        @Override
        YangQNameExpr createExpr(String localName) {
            return YangQNameExpr.of((UnresolvedQName)UnresolvedQName.Unqualified.of((String)localName));
        }

        @Override
        YangQNameExpr createExpr(String prefix, String localName) {
            return YangQNameExpr.of((UnresolvedQName)UnresolvedQName.Qualified.of((String)prefix, (String)localName));
        }

        @Override
        YangLocationPath.QNameStep createChildStep(String localName, Collection<YangExpr> predicates) {
            return YangXPathAxis.CHILD.asStep((UnresolvedQName)UnresolvedQName.Unqualified.of((String)localName), predicates);
        }

        @Override
        YangLocationPath.QNameStep createChildStep(String prefix, String localName, Collection<YangExpr> predicates) {
            return YangXPathAxis.CHILD.asStep((UnresolvedQName)UnresolvedQName.Qualified.of((String)prefix, (String)localName), predicates);
        }
    }
}

