/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.xds;

import org.openehealth.ipf.boot.atna.IpfAtnaAutoConfiguration;
import org.openehealth.ipf.boot.xds.IpfXdsConfigurationProperties;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.correlation.SpringCacheAsynchronyCorrelator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={IpfAtnaAutoConfiguration.class})
@EnableConfigurationProperties(value={IpfXdsConfigurationProperties.class})
public class IpfXdsAutoConfiguration {
    private final IpfXdsConfigurationProperties xdsConfig;

    public IpfXdsAutoConfiguration(IpfXdsConfigurationProperties xdsConfig) {
        this.xdsConfig = xdsConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={AsynchronyCorrelator.class})
    @ConditionalOnSingleCandidate(value=CacheManager.class)
    @ConditionalOnProperty(value={"ipf.xds.caching"})
    public AsynchronyCorrelator cachingAsynchronyCorrelator(CacheManager cacheManager) {
        return new SpringCacheAsynchronyCorrelator(cacheManager);
    }
}

