/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import io.vertx.core.net.JksOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.PfxOptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.openehealth.ipf.commons.audit.VertxTlsParameters;

public class CustomTlsParameters
implements VertxTlsParameters {
    private String provider = "SunJSSE";
    private String tlsProtocol = "TLSv1.2";
    private String certificateType = "SunX509";
    private String certAlias;
    private String keyStoreType;
    private String trustStoreType;
    private String keyStoreFile;
    private String keyStorePassword;
    private String trustStoreFile;
    private String trustStorePassword;
    private String enabledCipherSuites;
    private String enabledProtocols;
    private int sessionTimeout;
    private boolean performDomainValidation;
    private final List<String> sniHostnames = new ArrayList<String>();

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setTlsProtocol(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setPerformDomainValidation(boolean performDomainValidation) {
        this.performDomainValidation = performDomainValidation;
    }

    public List<String> getSniHostnames() {
        return this.sniHostnames;
    }

    public CustomTlsParameters() {
        this.trustStoreType = this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        this.keyStoreFile = System.getProperty("javax.net.ssl.keyStore");
        this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        this.trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        this.enabledCipherSuites = System.getProperty("https.ciphersuites");
        this.enabledProtocols = System.getProperty("jdk.tls.client.protocols", "TLSv1.2");
    }

    private Function<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryConfigurer() {
        return sslSocketFactory -> new SSLSocketFactoryDecorator((SSLSocketFactory)sslSocketFactory, this.sslSocketConfigurer());
    }

    private Function<SSLSocket, SSLSocket> sslSocketConfigurer() {
        return sslSocket -> {
            SSLParameters sslParameters;
            if (this.enabledCipherSuites != null) {
                sslSocket.setEnabledCipherSuites(this.split(this.enabledCipherSuites));
            }
            if (this.enabledProtocols != null) {
                sslSocket.setEnabledProtocols(this.split(this.enabledProtocols));
            }
            if (this.sniHostnames.isEmpty()) {
                sslParameters = sslSocket.getSSLParameters();
                sslParameters.setServerNames(this.sniHostnames.stream().map(SNIHostName::new).collect(Collectors.toList()));
                sslSocket.setSSLParameters(sslParameters);
            }
            if (this.performDomainValidation) {
                sslParameters = sslSocket.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslSocket.setSSLParameters(sslParameters);
            }
            return sslSocket;
        };
    }

    private Function<SSLEngine, SSLEngine> sslEngineConfigurer() {
        return sslEngine -> {
            if (this.enabledCipherSuites != null) {
                sslEngine.setEnabledCipherSuites(this.split(this.enabledCipherSuites));
            }
            if (this.enabledProtocols != null) {
                sslEngine.setEnabledProtocols(this.split(this.enabledProtocols));
            }
            return sslEngine;
        };
    }

    private String[] split(String s) {
        return s.split("\\s*,\\s*");
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            KeyStore keyStore = this.getKeyStore(this.keyStoreType, this.keyStoreFile, this.keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.certificateType, this.provider);
            keyManagerFactory.init(keyStore, this.keyStorePassword.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            if (keyManagers != null && this.certAlias != null) {
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new AliasX509ExtendedKeyManager((X509KeyManager)keyManagers[i], this.certAlias);
                }
            }
            KeyStore trustStore = this.getKeyStore(this.trustStoreType, this.trustStoreFile, this.trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.certificateType, this.provider);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = new SecureRandom();
            SSLContext sslContext = SSLContext.getInstance(this.tlsProtocol, this.provider);
            sslContext.init(keyManagers, trustManagers, secureRandom);
            if (this.sessionTimeout > 0) {
                sslContext.getClientSessionContext().setSessionTimeout(this.sessionTimeout);
            }
            return new CustomSSLContext(new SSLContextSpiDecorator(sslContext, this.sslEngineConfigurer(), this.sslSocketFactoryConfigurer()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initNetClientOptions(NetClientOptions options) {
        if ("JKS".equalsIgnoreCase(this.keyStoreType)) {
            options.setKeyStoreOptions(new JksOptions().setPath(this.keyStoreFile).setPassword(this.keyStorePassword));
        } else {
            options.setPfxKeyCertOptions(new PfxOptions().setPath(this.keyStoreFile).setPassword(this.keyStorePassword));
        }
        if ("JKS".equalsIgnoreCase(this.trustStoreType)) {
            options.setTrustStoreOptions(new JksOptions().setPath(this.trustStoreFile).setPassword(this.trustStorePassword));
        } else {
            options.setPfxTrustOptions(new PfxOptions().setPath(this.trustStoreFile).setPassword(this.trustStorePassword));
        }
        Stream.of(this.split(this.enabledProtocols)).forEach(arg_0 -> ((NetClientOptions)options).addEnabledSecureTransportProtocol(arg_0));
        if (this.enabledCipherSuites != null) {
            Stream.of(this.split(this.enabledCipherSuites)).forEach(arg_0 -> ((NetClientOptions)options).addEnabledCipherSuite(arg_0));
        }
    }

    private KeyStore getKeyStore(String type, String storePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        try (InputStream in = Files.newInputStream(Paths.get(storePath, new String[0]), new OpenOption[0]);){
            keyStore.load(in, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private static final class AliasX509ExtendedKeyManager
    extends X509ExtendedKeyManager {
        private final String certAlias;
        private final X509KeyManager keyManager;

        public AliasX509ExtendedKeyManager(X509KeyManager keyManager, String certAlias) {
            this.keyManager = keyManager;
            this.certAlias = certAlias;
        }

        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            return this.certAlias != null ? this.certAlias : this.keyManager.chooseClientAlias(keyTypes, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.certAlias != null ? this.certAlias : this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.certAlias != null ? this.certAlias : super.chooseEngineServerAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
            return this.certAlias != null ? this.certAlias : super.chooseEngineClientAlias(keyTypes, issuers, engine);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }
    }

    private static final class SSLSocketFactoryDecorator
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final Function<SSLSocket, SSLSocket> sslSocketConfigurer;

        public SSLSocketFactoryDecorator(SSLSocketFactory delegate, Function<SSLSocket, SSLSocket> sslSocketConfigurer) {
            this.delegate = delegate;
            this.sslSocketConfigurer = sslSocketConfigurer;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.configureSocket(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.configureSocket(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.configureSocket(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.configureSocket(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.configureSocket(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.configureSocket(this.delegate.createSocket(address, port, localAddress, localPort));
        }

        public SSLSocketFactory getDelegate() {
            return this.delegate;
        }

        private Socket configureSocket(Socket s) {
            SSLSocket socket = (SSLSocket)s;
            return this.sslSocketConfigurer.apply(socket);
        }
    }

    private static final class SSLContextSpiDecorator
    extends SSLContextSpi {
        private final SSLContext sslContext;
        private final Function<SSLEngine, SSLEngine> sslEngineConfigurer;
        private final Function<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryConfigurer;

        public SSLContextSpiDecorator(SSLContext sslContext, Function<SSLEngine, SSLEngine> sslEngineConfigurer, Function<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryConfigurer) {
            this.sslContext = sslContext;
            this.sslEngineConfigurer = sslEngineConfigurer;
            this.sslSocketFactoryConfigurer = sslSocketFactoryConfigurer;
        }

        SSLContext getDelegate() {
            return this.sslContext;
        }

        @Override
        protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            this.sslContext.init(keyManagers, trustManagers, secureRandom);
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            SSLSocketFactory factory = this.sslContext.getSocketFactory();
            return this.sslSocketFactoryConfigurer.apply(factory);
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            SSLEngine engine = this.sslContext.createSSLEngine();
            return this.sslEngineConfigurer.apply(engine);
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String host, int port) {
            SSLEngine engine = this.sslContext.createSSLEngine(host, port);
            return this.sslEngineConfigurer.apply(engine);
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            return this.sslContext.getServerSessionContext();
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            return this.sslContext.getClientSessionContext();
        }
    }

    private static final class CustomSSLContext
    extends SSLContext {
        CustomSSLContext(SSLContextSpiDecorator sslContextSpiDecorator) {
            super(sslContextSpiDecorator, sslContextSpiDecorator.getDelegate().getProvider(), sslContextSpiDecorator.getDelegate().getProtocol());
        }
    }
}

