/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.codes;

import org.openehealth.ipf.commons.audit.types.EnumeratedCodedValue;
import org.openehealth.ipf.commons.audit.types.EnumeratedValueSet;
import org.openehealth.ipf.commons.audit.types.EventId;

public enum EventIdCode implements EventId,
EnumeratedCodedValue<EventId>
{
    ApplicationActivity("110100", "Application Activity"),
    AuditLogUsed("110101", "Audit Log Used"),
    BeginTransferringDICOMInstances("110102", "Begin Transferring DICOM Instances"),
    DICOMInstancesAccessed("110103", "DICOM Instances Accessed"),
    DICOMInstancesTransferred("110104", "DICOM Instances Transferred"),
    DICOMStudyDeleted("110105", "DICOM Study Deleted"),
    Export("110106", "Export"),
    Import("110107", "Import"),
    NetworkEntry("110108", "Network Entry"),
    OrderRecord("110109", "Order Record"),
    PatientRecord("110110", "Patient Record"),
    ProcedureRecord("110111", "Procedure Record"),
    Query("110112", "Query"),
    SecurityAlert("110113", "Security Alert"),
    UserAuthentication("110114", "User Authentication");

    private final EventId value;

    private EventIdCode(String code, String displayName) {
        this.value = EventId.of(code, "DCM", displayName);
    }

    public static EventIdCode enumForCode(String code) {
        return EnumeratedValueSet.enumForCode(EventIdCode.class, code);
    }

    @Override
    public EventId getValue() {
        return this.value;
    }
}

