/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.EventTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class ApplicationActivityBuilder<T extends ApplicationActivityBuilder<T>>
extends BaseAuditMessageBuilder<T> {
    public ApplicationActivityBuilder(EventOutcomeIndicator outcome, EventType type) {
        this(outcome, null, type);
    }

    public ApplicationActivityBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventType type) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Execute, (EventId)EventIdCode.ApplicationActivity, type, (PurposeOfUse[])null);
    }

    public T addApplicationStarterParticipant(String userId) {
        return this.addApplicationStarterParticipant(userId, null, null, null);
    }

    public T addApplicationStarterParticipant(String userId, String altUserId, String userName, String networkId) {
        return (T)((ApplicationActivityBuilder)this.addActiveParticipant(userId, altUserId, userName, true, Collections.singletonList(ActiveParticipantRoleIdCode.ApplicationLauncher), networkId));
    }

    public T setApplicationParticipant(String userId, String altUserId, String userName, String networkId) {
        return (T)((ApplicationActivityBuilder)this.addActiveParticipant(userId, altUserId, userName, false, Collections.singletonList(ActiveParticipantRoleIdCode.Application), networkId));
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Application)).size() != 1) {
            throw new AuditException("Must have exactly one Application Active Participant");
        }
    }

    public static class ApplicationStop
    extends ApplicationActivityBuilder<ApplicationStop> {
        public ApplicationStop(EventOutcomeIndicator outcome) {
            this(outcome, (String)null);
        }

        public ApplicationStop(EventOutcomeIndicator outcome, String eventOutcomeDescription) {
            super(outcome, eventOutcomeDescription, EventTypeCode.ApplicationStop);
        }
    }

    public static class ApplicationStart
    extends ApplicationActivityBuilder<ApplicationStart> {
        public ApplicationStart(EventOutcomeIndicator outcome) {
            this(outcome, (String)null);
        }

        public ApplicationStart(EventOutcomeIndicator outcome, String eventOutcomeDescription) {
            super(outcome, eventOutcomeDescription, EventTypeCode.ApplicationStart);
        }
    }
}

