/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.NetworkAccessPointTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.MediaType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class DataImportBuilder
extends BaseAuditMessageBuilder<DataImportBuilder> {
    public DataImportBuilder(EventOutcomeIndicator outcome, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(outcome, null, eventType, purposesOfUse);
    }

    public DataImportBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(outcome, eventOutcomeDescription, EventActionCode.Create, eventType, purposesOfUse);
    }

    public DataImportBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, eventActionCode, (EventId)EventIdCode.Import, eventType, purposesOfUse);
    }

    public DataImportBuilder addImportingParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return (DataImportBuilder)this.addDestinationActiveParticipant(userId, altUserId, userName, networkAccessPointId, userIsRequestor);
    }

    public DataImportBuilder addSourceParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return (DataImportBuilder)super.addSourceActiveParticipant(userId, altUserId, userName, networkAccessPointId, userIsRequestor);
    }

    public DataImportBuilder setSourceMediaParticipant(String userId, String altUserId, String userName, NetworkAccessPointTypeCode networkAccessPointType, String networkAccessPointId, String mediaIdentifier, MediaType mediaType) {
        return (DataImportBuilder)this.addActiveParticipant(userId, altUserId, userName, false, Collections.singletonList(ActiveParticipantRoleIdCode.SourceMedia), networkAccessPointId, networkAccessPointType, mediaIdentifier, Objects.requireNonNull(mediaType));
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Destination)).isEmpty()) {
            throw new AuditException("Must have one or more ActiveParticipant with RoleIDCode Destination");
        }
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.SourceMedia)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode SourceMedia");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.PatientNumber).isEmpty()) {
            throw new AuditException("Must one or more ParticipantObjectIdentification with ParticipantObjectIDTypeCode PatientNumber");
        }
    }
}

