/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class DicomInstancesAccessedBuilder
extends BaseAuditMessageBuilder<DicomInstancesAccessedBuilder> {
    public DicomInstancesAccessedBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, eventActionCode, (EventId)EventIdCode.DICOMInstancesAccessed, eventType, purposesOfUse);
    }

    public DicomInstancesAccessedBuilder setPatientParticipantObject(String patientId, String patientName) {
        if (patientId != null) {
            this.addPatientParticipantObject(patientId, patientName, Collections.emptyList(), null);
        }
        return (DicomInstancesAccessedBuilder)this.self();
    }

    @Override
    public void validate() {
        super.validate();
        int participants = this.getMessage().getActiveParticipants().size();
        if (participants < 1 || participants > 2) {
            throw new AuditException("Must have one or two ActiveParticipants");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.StudyInstanceUID).isEmpty()) {
            throw new AuditException("Must have one or more ParticipantObjectIdentification with ParticipantObjectIDTypeCode StudyInstanceUID");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.PatientNumber).size() != 1) {
            throw new AuditException("Must one ParticipantObjectIdentification with ParticipantObjectIDTypeCode PatientNumber");
        }
    }
}

