/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class DicomInstancesTransferredBuilder
extends BaseAuditMessageBuilder<DicomInstancesTransferredBuilder> {
    public DicomInstancesTransferredBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, eventActionCode, (EventId)EventIdCode.DICOMInstancesTransferred, eventType, purposesOfUse);
    }

    public DicomInstancesTransferredBuilder setSendingProcessParticipant(String userId, String altUserId, String userName, String networkId, boolean userIsRequestor) {
        return (DicomInstancesTransferredBuilder)this.addSourceActiveParticipant(userId, altUserId, userName, networkId, userIsRequestor);
    }

    public DicomInstancesTransferredBuilder setReceivingProcessParticipant(String userId, String altUserId, String userName, String networkId, boolean userIsRequestor) {
        return (DicomInstancesTransferredBuilder)this.addDestinationActiveParticipant(userId, altUserId, userName, networkId, userIsRequestor);
    }

    public DicomInstancesTransferredBuilder setPatientParticipantObject(String patientId, String patientName) {
        if (patientId != null) {
            this.addPatientParticipantObject(patientId, patientName, Collections.emptyList(), null);
        }
        return (DicomInstancesTransferredBuilder)this.self();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Source)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode Source");
        }
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Destination)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode Destination");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.PatientNumber).size() != 1) {
            throw new AuditException("Must one ParticipantObjectIdentification with ParticipantObjectIDTypeCode PatientNumber");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.StudyInstanceUID).isEmpty()) {
            throw new AuditException("Must have one or more ParticipantObjectIdentification with ParticipantObjectIDTypeCode StudyInstanceUID");
        }
    }
}

