/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.EventTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class NetworkEntryBuilder
extends BaseAuditMessageBuilder<NetworkEntryBuilder> {
    public NetworkEntryBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventTypeCode eventTypeCode) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Read, (EventId)EventIdCode.NetworkEntry, (EventType)eventTypeCode, (PurposeOfUse[])null);
    }

    public NetworkEntryBuilder setSystemParticipant(String userId, String altUserId, String userName, ActiveParticipantRoleIdCode roleId, String networkId) {
        return (NetworkEntryBuilder)this.addActiveParticipant(userId, altUserId, userName, false, Collections.singletonList(roleId), networkId);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().getActiveParticipants().size() != 1) {
            throw new AuditException("Must have one ActiveParticipant");
        }
    }

    public static class LeavingNetwork
    extends NetworkEntryBuilder {
        public LeavingNetwork(EventOutcomeIndicator outcome) {
            this(outcome, null);
        }

        public LeavingNetwork(EventOutcomeIndicator outcome, String eventOutcomeDescription) {
            super(outcome, eventOutcomeDescription, EventTypeCode.Detach);
        }
    }

    public static class EnteringNetwork
    extends NetworkEntryBuilder {
        public EnteringNetwork(EventOutcomeIndicator outcome) {
            this(outcome, null);
        }

        public EnteringNetwork(EventOutcomeIndicator outcome, String eventOutcomeDescription) {
            super(outcome, eventOutcomeDescription, EventTypeCode.Attach);
        }
    }
}

