/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.List;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class PatientRecordBuilder
extends BaseAuditMessageBuilder<PatientRecordBuilder> {
    public PatientRecordBuilder(EventOutcomeIndicator outcome, EventActionCode action, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(outcome, null, action, eventType, purposesOfUse);
    }

    public PatientRecordBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode action, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, action, (EventId)EventIdCode.PatientRecord, eventType, purposesOfUse);
    }

    public PatientRecordBuilder addUserParticipant(String userId, String altUserId, String userName, String networkAccessPointId, List<ActiveParticipantRoleId> roleIds, boolean userIsRequestor) {
        return (PatientRecordBuilder)this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, roleIds, networkAccessPointId);
    }

    public PatientRecordBuilder addPatient(String patientId, String patientName, List<TypeValuePairType> details) {
        return (PatientRecordBuilder)this.addPatientParticipantObject(patientId, patientName, details, null);
    }

    public PatientRecordBuilder addPatient(String patientId, String patientName, List<TypeValuePairType> details, ParticipantObjectDataLifeCycle lifeCycle) {
        return (PatientRecordBuilder)this.addPatientParticipantObject(patientId, patientName, details, lifeCycle);
    }

    @Override
    public void validate() {
        super.validate();
        int aps = this.getMessage().getActiveParticipants().size();
        if (aps < 1 || aps > 2) {
            throw new AuditException("Must have one or two user ActiveParticipants");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.PatientNumber).size() != 1) {
            throw new AuditException("Must one ParticipantObjectIdentification with ParticipantObjectIDTypeCode PatientNumber");
        }
    }
}

