/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.EventTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class UserAuthenticationBuilder
extends BaseAuditMessageBuilder<UserAuthenticationBuilder> {
    public UserAuthenticationBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventTypeCode eventTypeCode, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Execute, (EventId)EventIdCode.UserAuthentication, (EventType)eventTypeCode, purposesOfUse);
    }

    public UserAuthenticationBuilder setAuthenticatedParticipant(String userId, String networkId) {
        return this.setAuthenticatedParticipant(userId, null, null, true, null, networkId);
    }

    public UserAuthenticationBuilder setAuthenticatedParticipant(String userId, String altUserId, String userName, boolean userIsRequestor, ActiveParticipantRoleIdCode roleId, String networkId) {
        return (UserAuthenticationBuilder)this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, roleId != null ? Collections.singletonList(roleId) : Collections.emptyList(), networkId);
    }

    public UserAuthenticationBuilder setAuthenticatingSystemParticipant(String userId, String networkId) {
        return this.setAuthenticatingSystemParticipant(userId, null, null, true, null, networkId);
    }

    public UserAuthenticationBuilder setAuthenticatingSystemParticipant(String userId, String altUserId, String userName, boolean userIsRequestor, ActiveParticipantRoleIdCode roleId, String networkId) {
        return (UserAuthenticationBuilder)this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, Collections.singletonList(roleId), networkId);
    }

    @Override
    public void validate() {
        super.validate();
        int participants = this.getMessage().getActiveParticipants().size();
        if (participants < 1 || participants > 2) {
            throw new AuditException("Must have one or two ActiveParticipants");
        }
    }

    public static class Logout
    extends UserAuthenticationBuilder {
        public Logout(EventOutcomeIndicator outcome, PurposeOfUse ... purposeOfUse) {
            this(outcome, (String)null, purposeOfUse);
        }

        public Logout(EventOutcomeIndicator outcome, String eventOutcomeDescription, PurposeOfUse ... purposeOfUse) {
            super(outcome, eventOutcomeDescription, EventTypeCode.Logout, purposeOfUse);
        }
    }

    public static class Login
    extends UserAuthenticationBuilder {
        public Login(EventOutcomeIndicator outcome, PurposeOfUse ... purposeOfUse) {
            this(outcome, (String)null, purposeOfUse);
        }

        public Login(EventOutcomeIndicator outcome, String eventOutcomeDescription, PurposeOfUse ... purposeOfUse) {
            super(outcome, eventOutcomeDescription, EventTypeCode.Login, purposeOfUse);
        }
    }
}

