/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.marshal.dicom;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openehealth.ipf.commons.audit.marshal.SerializationStrategy;
import org.openehealth.ipf.commons.audit.model.ActiveParticipantType;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.model.AuditSourceIdentificationType;
import org.openehealth.ipf.commons.audit.model.DicomObjectDescriptionType;
import org.openehealth.ipf.commons.audit.model.EventIdentificationType;
import org.openehealth.ipf.commons.audit.model.ParticipantObjectIdentificationType;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.AuditSource;
import org.openehealth.ipf.commons.audit.types.CodedValueType;
import org.openehealth.ipf.commons.audit.types.EnumeratedValueSet;

public class DICOM2016a
implements SerializationStrategy {
    private static final XMLOutputter PRETTY = new XMLOutputter(Format.getPrettyFormat().setOmitDeclaration(true));
    private static final XMLOutputter COMPACT = new XMLOutputter(Format.getCompactFormat().setOmitDeclaration(true));

    @Override
    public void marshal(AuditMessage auditMessage, Writer writer, boolean pretty) throws IOException {
        this.serialize(auditMessage, writer, pretty ? PRETTY : COMPACT);
    }

    private void serialize(AuditMessage auditMessage, Writer writer, XMLOutputter outputter) throws IOException {
        Element element = new Element("AuditMessage");
        element.addContent((Content)this.eventIdentification(auditMessage.getEventIdentification()));
        auditMessage.getActiveParticipants().stream().map(this::activeParticipant).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        element.addContent((Content)this.auditSourceIdentification(auditMessage.getAuditSourceIdentification()));
        auditMessage.getParticipantObjectIdentifications().stream().map(this::participantObjectIdentification).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        outputter.output(new Document(element), writer);
    }

    protected Content activeParticipant(ActiveParticipantType activeParticipant) {
        Element element = new Element("ActiveParticipant");
        element.setAttribute("UserID", activeParticipant.getUserID());
        this.conditionallyAddAttribute(element, "AlternativeUserID", activeParticipant.getAlternativeUserID());
        this.conditionallyAddAttribute(element, "UserName", activeParticipant.getUserName());
        element.setAttribute("UserIsRequestor", Boolean.toString(activeParticipant.isUserIsRequestor()));
        this.conditionallyAddAttribute(element, "NetworkAccessPointID", activeParticipant.getNetworkAccessPointID());
        this.conditionallyAddAttribute(element, "NetworkAccessPointTypeCode", activeParticipant.getNetworkAccessPointTypeCode());
        if (activeParticipant.getRoleIDCodes() != null) {
            activeParticipant.getRoleIDCodes().stream().map(roleIdCode -> this.codedValueType("RoleIDCode", (CodedValueType)roleIdCode)).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        }
        if (activeParticipant.getMediaType() != null) {
            element.addContent((Content)new Element("MediaIdentifier").addContent((Content)this.codedValueType("MediaType", activeParticipant.getMediaType())));
        }
        return element;
    }

    protected Element eventIdentification(EventIdentificationType eventIdentification) {
        Element element = new Element("EventIdentification");
        if (eventIdentification != null) {
            element.setAttribute("EventActionCode", eventIdentification.getEventActionCode().getValue());
            element.setAttribute("EventDateTime", eventIdentification.getEventDateTime().toString());
            element.setAttribute("EventOutcomeIndicator", eventIdentification.getEventOutcomeIndicator().getValue().toString());
            if (eventIdentification.getEventID() != null) {
                element.addContent((Content)this.codedValueType("EventID", eventIdentification.getEventID()));
            }
            eventIdentification.getEventTypeCode().stream().map(eventTypeCode -> this.codedValueType("EventTypeCode", (CodedValueType)eventTypeCode)).forEach(arg_0 -> ((Element)element).addContent(arg_0));
            if (eventIdentification.getEventOutcomeDescription() != null) {
                element.addContent((Content)new Element("EventOutcomeDescription").addContent(eventIdentification.getEventOutcomeDescription()));
            }
            eventIdentification.getPurposesOfUse().stream().map(purposeOfUse -> this.codedValueType("PurposeOfUse", (CodedValueType)purposeOfUse)).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        }
        return element;
    }

    protected Element participantObjectIdentification(ParticipantObjectIdentificationType poi) {
        Element element = new Element("ParticipantObjectIdentification");
        if (poi != null) {
            this.conditionallyAddAttribute(element, "ParticipantObjectID", poi.getParticipantObjectID());
            if (poi.getParticipantObjectTypeCode() != null) {
                this.conditionallyAddAttribute(element, "ParticipantObjectTypeCode", poi.getParticipantObjectTypeCode().getValue().toString());
            }
            this.conditionallyAddAttribute(element, "ParticipantObjectTypeCodeRole", poi.getParticipantObjectTypeCodeRole());
            this.conditionallyAddAttribute(element, "ParticipantObjectDataLifeCycle", poi.getParticipantObjectDataLifeCycle());
            this.conditionallyAddAttribute(element, "ParticipantObjectSensitivity", poi.getParticipantObjectSensitivity());
            element.addContent((Content)this.codedValueType("ParticipantObjectIDTypeCode", poi.getParticipantObjectIDTypeCode()));
            if (poi.getParticipantObjectName() != null) {
                element.addContent((Content)new Element("ParticipantObjectName").addContent(poi.getParticipantObjectName()));
            }
            if (poi.getParticipantObjectQuery() != null) {
                element.addContent((Content)new Element("ParticipantObjectQuery").addContent(new String(Base64.getEncoder().encode(poi.getParticipantObjectQuery()), StandardCharsets.UTF_8)));
            }
            poi.getParticipantObjectDetails().stream().map(participantObjectDetail -> this.typeValuePairType("ParticipantObjectDetail", (TypeValuePairType)participantObjectDetail)).forEach(arg_0 -> ((Element)element).addContent(arg_0));
            poi.getParticipantObjectDescriptions().stream().map(this::dicomObjectDescription).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        }
        return element;
    }

    protected Element auditSourceIdentification(AuditSourceIdentificationType auditSourceIdentification) {
        Element element = new Element("AuditSourceIdentification");
        if (auditSourceIdentification != null) {
            this.conditionallyAddAttribute(element, "AuditEnterpriseSiteID", auditSourceIdentification.getAuditEnterpriseSiteID());
            this.conditionallyAddAttribute(element, "AuditSourceID", auditSourceIdentification.getAuditSourceID());
            auditSourceIdentification.getAuditSourceType().stream().map(this::auditSourceType).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        }
        return element;
    }

    protected Element auditSourceType(AuditSource auditSourceType) {
        return new Element("AuditSourceTypeCode").addContent(auditSourceType.getCode());
    }

    protected Element codedValueType(String tagName, CodedValueType codedValue) {
        Element element = new Element(tagName);
        element.setAttribute("csd-code", codedValue.getCode());
        this.conditionallyAddAttribute(element, "codeSystemName", codedValue.getCodeSystemName());
        this.conditionallyAddAttribute(element, "displayName", codedValue.getDisplayName());
        this.conditionallyAddAttribute(element, "originalText", codedValue.getOriginalText());
        return element;
    }

    protected Element typeValuePairType(String tagName, TypeValuePairType typeValuePair) {
        Element element = new Element(tagName);
        element.setAttribute("type", typeValuePair.getType());
        element.setAttribute("value", new String(Base64.getEncoder().encode(typeValuePair.getValue()), StandardCharsets.UTF_8));
        return element;
    }

    protected Element dicomObjectDescription(DicomObjectDescriptionType dicomObjectDescription) {
        Element pod = new Element("ParticipantObjectDescription");
        dicomObjectDescription.getMPPS().forEach(mpps -> pod.addContent((Content)new Element("MPPS").setAttribute("UID", mpps)));
        dicomObjectDescription.getAccession().forEach(accession -> pod.addContent((Content)new Element("Accession").setAttribute("Number", accession)));
        dicomObjectDescription.getSOPClasses().forEach(sop -> {
            Element sopClass = new Element("SOPClass").setAttribute("NumberOfInstances", String.valueOf(sop.getNumberOfInstances()));
            this.conditionallyAddAttribute(sopClass, "UID", sop.getUid());
            sop.getInstanceUids().forEach(uid -> sopClass.addContent((Content)new Element("Instance").setAttribute("UID", uid)));
            pod.addContent((Content)sopClass);
        });
        if (!dicomObjectDescription.getStudyIDs().isEmpty()) {
            Element participantObjectContainsStudy = new Element("ParticipantObjectContainsStudy");
            dicomObjectDescription.getStudyIDs().forEach(studyID -> participantObjectContainsStudy.addContent((Content)new Element("StudyIDs").setAttribute("UID", studyID)));
            pod.addContent((Content)participantObjectContainsStudy);
        }
        if (dicomObjectDescription.getEncrypted() != null) {
            pod.addContent((Content)new Element("Encrypted").addContent(String.valueOf(dicomObjectDescription.getEncrypted())));
        }
        if (dicomObjectDescription.getAnonymized() != null) {
            pod.addContent((Content)new Element("Anonymized").addContent(String.valueOf(dicomObjectDescription.getAnonymized())));
        }
        return pod;
    }

    protected void conditionallyAddAttribute(Element element, String attributeName, String value) {
        if (value != null) {
            element.setAttribute(attributeName, value);
        }
    }

    protected void conditionallyAddAttribute(Element element, String attributeName, EnumeratedValueSet<?> value) {
        if (value != null) {
            element.setAttribute(attributeName, value.getValue().toString());
        }
    }
}

