/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.DicomObjectDescriptionType;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.model.Validateable;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;

public class ParticipantObjectIdentificationType
implements Serializable,
Validateable {
    @NonNull
    private String participantObjectID;
    @NonNull
    private ParticipantObjectIdType participantObjectIDTypeCode;
    private String participantObjectName;
    private byte[] participantObjectQuery;
    private ParticipantObjectTypeCode participantObjectTypeCode;
    private ParticipantObjectTypeCodeRole participantObjectTypeCodeRole;
    private ParticipantObjectDataLifeCycle participantObjectDataLifeCycle;
    private String participantObjectSensitivity;
    private List<TypeValuePairType> participantObjectDetails;
    private List<DicomObjectDescriptionType> participantObjectDescriptions;

    public ParticipantObjectIdentificationType(String participantObjectID, ParticipantObjectIdType participantObjectIDTypeCode) {
        this.participantObjectID = Objects.requireNonNull(participantObjectID, "participantObjectID must be not null");
        this.participantObjectIDTypeCode = Objects.requireNonNull(participantObjectIDTypeCode, "participantObjectIDTypeCode must be not null");
    }

    public List<TypeValuePairType> getParticipantObjectDetails() {
        if (this.participantObjectDetails == null) {
            this.participantObjectDetails = new ArrayList<TypeValuePairType>();
        }
        return this.participantObjectDetails;
    }

    public List<DicomObjectDescriptionType> getParticipantObjectDescriptions() {
        if (this.participantObjectDescriptions == null) {
            this.participantObjectDescriptions = new ArrayList<DicomObjectDescriptionType>();
        }
        return this.participantObjectDescriptions;
    }

    @Override
    public void validate() {
        if (this.participantObjectIDTypeCode == ParticipantObjectIdTypeCode.StudyInstanceUID && this.getParticipantObjectDescriptions().isEmpty()) {
            throw new AuditException("DICOM Object Descriptions must be present for StudyInstanceUID participant object ID types");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParticipantObjectIdentificationType)) {
            return false;
        }
        ParticipantObjectIdentificationType other = (ParticipantObjectIdentificationType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$participantObjectID = this.getParticipantObjectID();
        String other$participantObjectID = other.getParticipantObjectID();
        if (this$participantObjectID == null ? other$participantObjectID != null : !this$participantObjectID.equals(other$participantObjectID)) {
            return false;
        }
        ParticipantObjectIdType this$participantObjectIDTypeCode = this.getParticipantObjectIDTypeCode();
        ParticipantObjectIdType other$participantObjectIDTypeCode = other.getParticipantObjectIDTypeCode();
        if (this$participantObjectIDTypeCode == null ? other$participantObjectIDTypeCode != null : !this$participantObjectIDTypeCode.equals(other$participantObjectIDTypeCode)) {
            return false;
        }
        String this$participantObjectName = this.getParticipantObjectName();
        String other$participantObjectName = other.getParticipantObjectName();
        if (this$participantObjectName == null ? other$participantObjectName != null : !this$participantObjectName.equals(other$participantObjectName)) {
            return false;
        }
        if (!Arrays.equals(this.getParticipantObjectQuery(), other.getParticipantObjectQuery())) {
            return false;
        }
        ParticipantObjectTypeCode this$participantObjectTypeCode = this.getParticipantObjectTypeCode();
        ParticipantObjectTypeCode other$participantObjectTypeCode = other.getParticipantObjectTypeCode();
        if (this$participantObjectTypeCode == null ? other$participantObjectTypeCode != null : !this$participantObjectTypeCode.equals(other$participantObjectTypeCode)) {
            return false;
        }
        ParticipantObjectTypeCodeRole this$participantObjectTypeCodeRole = this.getParticipantObjectTypeCodeRole();
        ParticipantObjectTypeCodeRole other$participantObjectTypeCodeRole = other.getParticipantObjectTypeCodeRole();
        if (this$participantObjectTypeCodeRole == null ? other$participantObjectTypeCodeRole != null : !this$participantObjectTypeCodeRole.equals(other$participantObjectTypeCodeRole)) {
            return false;
        }
        ParticipantObjectDataLifeCycle this$participantObjectDataLifeCycle = this.getParticipantObjectDataLifeCycle();
        ParticipantObjectDataLifeCycle other$participantObjectDataLifeCycle = other.getParticipantObjectDataLifeCycle();
        if (this$participantObjectDataLifeCycle == null ? other$participantObjectDataLifeCycle != null : !this$participantObjectDataLifeCycle.equals(other$participantObjectDataLifeCycle)) {
            return false;
        }
        String this$participantObjectSensitivity = this.getParticipantObjectSensitivity();
        String other$participantObjectSensitivity = other.getParticipantObjectSensitivity();
        if (this$participantObjectSensitivity == null ? other$participantObjectSensitivity != null : !this$participantObjectSensitivity.equals(other$participantObjectSensitivity)) {
            return false;
        }
        List<TypeValuePairType> this$participantObjectDetails = this.getParticipantObjectDetails();
        List<TypeValuePairType> other$participantObjectDetails = other.getParticipantObjectDetails();
        if (this$participantObjectDetails == null ? other$participantObjectDetails != null : !((Object)this$participantObjectDetails).equals(other$participantObjectDetails)) {
            return false;
        }
        List<DicomObjectDescriptionType> this$participantObjectDescriptions = this.getParticipantObjectDescriptions();
        List<DicomObjectDescriptionType> other$participantObjectDescriptions = other.getParticipantObjectDescriptions();
        return !(this$participantObjectDescriptions == null ? other$participantObjectDescriptions != null : !((Object)this$participantObjectDescriptions).equals(other$participantObjectDescriptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParticipantObjectIdentificationType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $participantObjectID = this.getParticipantObjectID();
        result = result * 59 + ($participantObjectID == null ? 43 : $participantObjectID.hashCode());
        ParticipantObjectIdType $participantObjectIDTypeCode = this.getParticipantObjectIDTypeCode();
        result = result * 59 + ($participantObjectIDTypeCode == null ? 43 : $participantObjectIDTypeCode.hashCode());
        String $participantObjectName = this.getParticipantObjectName();
        result = result * 59 + ($participantObjectName == null ? 43 : $participantObjectName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getParticipantObjectQuery());
        ParticipantObjectTypeCode $participantObjectTypeCode = this.getParticipantObjectTypeCode();
        result = result * 59 + ($participantObjectTypeCode == null ? 43 : $participantObjectTypeCode.hashCode());
        ParticipantObjectTypeCodeRole $participantObjectTypeCodeRole = this.getParticipantObjectTypeCodeRole();
        result = result * 59 + ($participantObjectTypeCodeRole == null ? 43 : $participantObjectTypeCodeRole.hashCode());
        ParticipantObjectDataLifeCycle $participantObjectDataLifeCycle = this.getParticipantObjectDataLifeCycle();
        result = result * 59 + ($participantObjectDataLifeCycle == null ? 43 : $participantObjectDataLifeCycle.hashCode());
        String $participantObjectSensitivity = this.getParticipantObjectSensitivity();
        result = result * 59 + ($participantObjectSensitivity == null ? 43 : $participantObjectSensitivity.hashCode());
        List<TypeValuePairType> $participantObjectDetails = this.getParticipantObjectDetails();
        result = result * 59 + ($participantObjectDetails == null ? 43 : ((Object)$participantObjectDetails).hashCode());
        List<DicomObjectDescriptionType> $participantObjectDescriptions = this.getParticipantObjectDescriptions();
        result = result * 59 + ($participantObjectDescriptions == null ? 43 : ((Object)$participantObjectDescriptions).hashCode());
        return result;
    }

    @NonNull
    public String getParticipantObjectID() {
        return this.participantObjectID;
    }

    public void setParticipantObjectID(@NonNull String participantObjectID) {
        if (participantObjectID == null) {
            throw new NullPointerException("participantObjectID is marked non-null but is null");
        }
        this.participantObjectID = participantObjectID;
    }

    @NonNull
    public ParticipantObjectIdType getParticipantObjectIDTypeCode() {
        return this.participantObjectIDTypeCode;
    }

    public void setParticipantObjectIDTypeCode(@NonNull ParticipantObjectIdType participantObjectIDTypeCode) {
        if (participantObjectIDTypeCode == null) {
            throw new NullPointerException("participantObjectIDTypeCode is marked non-null but is null");
        }
        this.participantObjectIDTypeCode = participantObjectIDTypeCode;
    }

    public String getParticipantObjectName() {
        return this.participantObjectName;
    }

    public void setParticipantObjectName(String participantObjectName) {
        this.participantObjectName = participantObjectName;
    }

    public byte[] getParticipantObjectQuery() {
        return this.participantObjectQuery;
    }

    public void setParticipantObjectQuery(byte[] participantObjectQuery) {
        this.participantObjectQuery = participantObjectQuery;
    }

    public ParticipantObjectTypeCode getParticipantObjectTypeCode() {
        return this.participantObjectTypeCode;
    }

    public void setParticipantObjectTypeCode(ParticipantObjectTypeCode participantObjectTypeCode) {
        this.participantObjectTypeCode = participantObjectTypeCode;
    }

    public ParticipantObjectTypeCodeRole getParticipantObjectTypeCodeRole() {
        return this.participantObjectTypeCodeRole;
    }

    public void setParticipantObjectTypeCodeRole(ParticipantObjectTypeCodeRole participantObjectTypeCodeRole) {
        this.participantObjectTypeCodeRole = participantObjectTypeCodeRole;
    }

    public ParticipantObjectDataLifeCycle getParticipantObjectDataLifeCycle() {
        return this.participantObjectDataLifeCycle;
    }

    public void setParticipantObjectDataLifeCycle(ParticipantObjectDataLifeCycle participantObjectDataLifeCycle) {
        this.participantObjectDataLifeCycle = participantObjectDataLifeCycle;
    }

    public String getParticipantObjectSensitivity() {
        return this.participantObjectSensitivity;
    }

    public void setParticipantObjectSensitivity(String participantObjectSensitivity) {
        this.participantObjectSensitivity = participantObjectSensitivity;
    }
}

