/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.NettyTLSSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.protocol.TLSSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.protocol.UDPSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.protocol.VertxTLSSyslogSenderImpl;

public enum AuditTransmissionChannel {
    UDP("UDP", UDPSyslogSenderImpl.class),
    NIO_UDP("NIO-UDP", UDPSyslogSenderImpl.class),
    VERTX_UDP("VERTX-UDP", UDPSyslogSenderImpl.class),
    TLS("TLS", TLSSyslogSenderImpl.class),
    NIO_TLS("NIO-TLS", NettyTLSSyslogSenderImpl.class),
    VERTX_TLS("VERTX-TLS", VertxTLSSyslogSenderImpl.class),
    NETTY_TLS("NETTY-TLS", NettyTLSSyslogSenderImpl.class);

    private final String protocolName;
    private final Class<? extends AuditTransmissionProtocol> protocol;

    private AuditTransmissionChannel(String protocolName, Class<? extends AuditTransmissionProtocol> protocol) {
        this.protocolName = protocolName;
        this.protocol = protocol;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public AuditTransmissionProtocol makeInstance(TlsParameters tlsParameters) {
        try {
            return this.protocol.getConstructor(TlsParameters.class).newInstance(tlsParameters);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    public static AuditTransmissionChannel fromProtocolName(String protocolName) {
        for (AuditTransmissionChannel channel : AuditTransmissionChannel.values()) {
            if (!channel.protocolName.equalsIgnoreCase(protocolName)) continue;
            return channel;
        }
        throw new IllegalArgumentException("Unknown audit protocol name: " + protocolName + ". Choose on of: " + Arrays.stream(AuditTransmissionChannel.values()).map(AuditTransmissionChannel::getProtocolName).collect(Collectors.joining(",")));
    }
}

