/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5424Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioTLSSyslogSenderImpl<H, D extends Destination<H>>
extends RFC5424Protocol
implements AuditTransmissionProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(NioTLSSyslogSenderImpl.class);
    private boolean loggingEnabled = false;
    private final TlsParameters tlsParameters;
    private final Map<String, D> destinations = new ConcurrentHashMap<String, D>();

    public NioTLSSyslogSenderImpl(TlsParameters tlsParameters) {
        this.tlsParameters = tlsParameters;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    protected abstract void customizeDestination(D var1);

    @Override
    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) throws Exception {
        if (auditMessage != null) {
            D destination = this.getDestination(auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort());
            byte[] msgBytes = this.getTransportPayload(auditMetadataProvider, auditMessage);
            byte[] length = String.format("%d ", msgBytes.length).getBytes();
            LOG.debug("Auditing to {}:{}", (Object)auditContext.getAuditRepositoryHostName(), (Object)auditContext.getAuditRepositoryPort());
            destination.write(length, msgBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private D getDestination(String host, int port) {
        Destination<Object> destination = (Destination)this.destinations.get(host + port);
        if (destination == null) {
            NioTLSSyslogSenderImpl nioTLSSyslogSenderImpl = this;
            synchronized (nioTLSSyslogSenderImpl) {
                destination = this.makeDestination(this.tlsParameters, host, port, this.loggingEnabled);
                this.customizeDestination(destination);
                Destination existing = this.destinations.put(host + port, destination);
                if (existing != null) {
                    existing.shutdown();
                }
            }
        }
        return (D)destination;
    }

    protected abstract D makeDestination(TlsParameters var1, String var2, int var3, boolean var4);

    @Override
    public void shutdown() {
        this.destinations.values().forEach(Destination::shutdown);
    }

    public static interface Destination<H> {
        public void write(byte[] ... var1);

        public void shutdown();

        public H getHandle();
    }
}

