/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import java.nio.charset.StandardCharsets;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5424Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxUDPSyslogSenderImpl
extends RFC5424Protocol
implements AuditTransmissionProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(VertxUDPSyslogSenderImpl.class);
    private final Vertx vertx;

    public VertxUDPSyslogSenderImpl() {
        this(Vertx.vertx());
    }

    public VertxUDPSyslogSenderImpl(TlsParameters tlsParameters) {
        this(Vertx.vertx());
    }

    public VertxUDPSyslogSenderImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) {
        DatagramSocketOptions options = new DatagramSocketOptions().setSendBufferSize(16384);
        DatagramSocket socket = this.vertx.createDatagramSocket(options);
        if (auditMessage != null) {
            byte[] msgBytes = this.getTransportPayload(auditMetadataProvider, auditMessage);
            LOG.debug("Auditing to {}:{}", (Object)auditContext.getAuditRepositoryHostName(), (Object)auditContext.getAuditRepositoryPort());
            LOG.trace("{}", (Object)new String(msgBytes, StandardCharsets.UTF_8));
            Buffer buffer = new BufferImpl().appendBytes(msgBytes);
            socket.send(buffer, auditContext.getAuditRepositoryPort(), auditContext.getAuditRepositoryHostName(), event -> {
                if (event.failed()) {
                    LOG.warn("Sending Audit Event via UDP failed");
                }
            });
        }
    }

    @Override
    public String getTransportName() {
        return AuditTransmissionChannel.VERTX_UDP.getProtocolName();
    }

    @Override
    public void shutdown() {
        this.vertx.close();
    }
}

