/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.queue.AbstractAuditMessageQueue;

public class BasicHttpAuditMessageQueue
extends AbstractAuditMessageQueue {
    private final URL url;
    private final String user;
    private final String password;
    private int connectTimeout = -1;
    private int readTimeout = -1;

    public BasicHttpAuditMessageQueue(URL url) {
        this(url, null, null);
    }

    public BasicHttpAuditMessageQueue(URL url, String user, String password) {
        this.url = Objects.requireNonNull(url, "url must not be null");
        this.user = user;
        this.password = password;
    }

    @Override
    protected void handle(AuditContext auditContext, String auditMessage) {
        try {
            HttpURLConnection connection = this.openConnection();
            byte[] buffer = auditMessage.getBytes(StandardCharsets.UTF_8);
            this.initializeConnection(connection, auditContext, buffer.length);
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(buffer);
                wr.flush();
            }
            int response = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            if (response >= 400) {
                throw new IOException("Encountered Status " + response + " with message " + responseMessage);
            }
        }
        catch (IOException e) {
            auditContext.getAuditExceptionHandler().handleException(auditContext, e, auditMessage);
        }
    }

    private void initializeConnection(HttpURLConnection connection, AuditContext auditContext, int length) throws ProtocolException {
        connection.setFixedLengthStreamingMode(length);
        connection.addRequestProperty("Content-Length", Long.toString(length));
        connection.addRequestProperty("X-IPF-ATNA-Timestamp", auditContext.getAuditMetadataProvider().getTimestamp());
        connection.addRequestProperty("X-IPF-ATNA-Hostname", auditContext.getAuditMetadataProvider().getHostname());
        connection.addRequestProperty("X-IPF-ATNA-ProcessID", auditContext.getAuditMetadataProvider().getProcessID());
        connection.addRequestProperty("X-IPF-ATNA-Application", auditContext.getAuditMetadataProvider().getSendingApplication());
        connection.addRequestProperty("Content-Type", "text/xml; charset=UTF-8");
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setUseCaches(false);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private HttpURLConnection openConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        if (this.user != null) {
            String auth = this.user + ":" + this.password;
            String authHeaderValue = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", authHeaderValue);
        }
        if (this.connectTimeout >= 0) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            connection.setConnectTimeout(this.readTimeout);
        }
        return connection;
    }
}

