/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;

public class CompositeAuditMessageQueue
implements AuditMessageQueue {
    private final List<AuditMessageQueue> queues;

    public CompositeAuditMessageQueue(List<AuditMessageQueue> queues) {
        this.queues = Objects.requireNonNull(queues);
    }

    @Override
    public void audit(AuditContext auditContext, AuditMessage ... auditMessages) {
        this.queues.forEach(q -> q.audit(auditContext, auditMessages));
    }

    @Override
    public void flush() {
        this.queues.forEach(AuditMessageQueue::flush);
    }

    @Override
    public void shutdown() {
        this.queues.forEach(AuditMessageQueue::shutdown);
    }

    public List<AuditMessageQueue> getQueues() {
        return this.queues;
    }
}

