/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.queue.AbstractAuditMessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuditMessageQueue
extends AbstractAuditMessageQueue {
    private static final String DEFAULT_LOGGER_NAME = "AUDIT";
    private Logger log;

    public LoggingAuditMessageQueue() {
        this.setPretty(true);
        this.setLoggerName(DEFAULT_LOGGER_NAME);
    }

    public void setLoggerName(String loggerName) {
        this.log = LoggerFactory.getLogger((String)Objects.requireNonNull(loggerName));
    }

    @Override
    protected synchronized void handle(AuditContext auditContext, String auditRecord) {
        if (auditRecord != null) {
            this.log.info(auditRecord);
        }
    }
}

