/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.ws.addressing.soap.MAPCodec;

public class MustUnderstandDecoratorInterceptor
extends AbstractSoapInterceptor {
    private final List<QName> mustUnderstandHeaders = new ArrayList<QName>();

    public MustUnderstandDecoratorInterceptor() {
        super("write");
        this.addAfter(MAPCodec.class.getName());
        this.addBefore(LoggingOutInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        List headers = message.getHeaders();
        for (QName name : this.mustUnderstandHeaders) {
            this.mustUnderstand(headers, name);
        }
    }

    public void addHeaders(List<String> headers) {
        for (String header : headers) {
            int namespaceEnd = header.indexOf(125);
            String namespace = header.substring(1, namespaceEnd);
            String name = header.substring(namespaceEnd + 1);
            this.mustUnderstandHeaders.add(new QName(namespace, name));
        }
    }

    public void addHeader(QName header) {
        this.mustUnderstandHeaders.add(header);
    }

    private Header getHeader(List<Header> headers, QName name) {
        for (Header header : headers) {
            if (!header.getName().equals(name)) continue;
            return header;
        }
        return null;
    }

    private void mustUnderstand(List<Header> headers, QName name) {
        Header header = this.getHeader(headers, name);
        if (header == null) {
            return;
        }
        if (header instanceof SoapHeader) {
            SoapHeader soapHeader = (SoapHeader)header;
            soapHeader.setMustUnderstand(true);
            return;
        }
        headers.remove(header);
        SoapHeader newHeader = new SoapHeader(name, header.getObject());
        newHeader.setMustUnderstand(true);
        headers.add((Header)newHeader);
    }
}

