/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.InterceptorUtils;
import org.openehealth.ipf.commons.ihe.ws.cxf.AbstractSafeInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openhealthtools.ihe.atna.auditor.models.rfc3881.CodedValueType;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractAuditInterceptor<T extends WsAuditDataset>
extends AbstractSafeInterceptor {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractAuditInterceptor.class);
    public static final String DATASET_CONTEXT_KEY = String.valueOf(AbstractAuditInterceptor.class.getName()) + ".DATASET";
    public static final String XUA_SAML_ASSERTION = String.valueOf(AbstractAuditInterceptor.class.getName()) + ".XUA_SAML_ASSERTION";
    public static final String WSSE_NS_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private final AuditStrategy<T> auditStrategy;
    private static final UnmarshallerFactory SAML_UNMARSHALLER_FACTORY;

    static {
        try {
            InitializationService.initialize();
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            SAML_UNMARSHALLER_FACTORY = registry.getUnmarshallerFactory();
        }
        catch (InitializationException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractAuditInterceptor(String phase, AuditStrategy<T> auditStrategy) {
        super(phase);
        Validate.notNull(auditStrategy);
        this.auditStrategy = auditStrategy;
    }

    protected T getAuditDataset(SoapMessage message) {
        WsAuditDataset auditDataset = (WsAuditDataset)((Object)InterceptorUtils.findContextualProperty((Message)message, DATASET_CONTEXT_KEY));
        if (auditDataset == null) {
            auditDataset = (WsAuditDataset)this.getAuditStrategy().createAuditDataset();
            if (auditDataset == null) {
                LOG.warn("Cannot obtain audit dataset instance, NPE is pending");
                return null;
            }
            message.getExchange().put((Object)DATASET_CONTEXT_KEY, (Object)auditDataset);
        }
        return (T)((Object)auditDataset);
    }

    protected AuditStrategy<T> getAuditStrategy() {
        return this.auditStrategy;
    }

    protected static void extractUserIdFromWSAddressing(SoapMessage message, boolean isInbound, boolean inverseWsaDirection, WsAuditDataset auditDataset) {
        AddressingProperties wsaProperties = (AddressingProperties)message.get((Object)(isInbound ? "javax.xml.ws.addressing.context.inbound" : "javax.xml.ws.addressing.context.outbound"));
        if (wsaProperties != null) {
            AttributedURIType address = null;
            if (inverseWsaDirection) {
                address = wsaProperties.getTo();
            } else {
                EndpointReferenceType replyTo = wsaProperties.getReplyTo();
                if (replyTo != null) {
                    address = replyTo.getAddress();
                }
            }
            if (address != null) {
                auditDataset.setUserId(address.getValue());
            }
        } else {
            LOG.error("Missing WS-Addressing headers");
        }
    }

    protected static void extractXuaUserNameFromSaml2Assertion(SoapMessage message, Header.Direction headerDirection, WsAuditDataset auditDataset) {
        String issuer;
        Assertion assertion = null;
        Object o = message.getContextualProperty(XUA_SAML_ASSERTION);
        if (o instanceof Assertion) {
            assertion = (Assertion)o;
        }
        if (assertion == null) {
            Header header = message.getHeader(new QName(WSSE_NS_URI, "Security"));
            if (header == null || !headerDirection.equals((Object)header.getDirection()) || !(header.getObject() instanceof Element)) {
                return;
            }
            Element headerElem = (Element)header.getObject();
            NodeList nodeList = headerElem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            Element assertionElem = (Element)nodeList.item(0);
            if (assertionElem == null) {
                return;
            }
            Unmarshaller unmarshaller = SAML_UNMARSHALLER_FACTORY.getUnmarshaller(assertionElem);
            try {
                assertion = (Assertion)unmarshaller.unmarshall(assertionElem);
            }
            catch (UnmarshallingException e) {
                LOG.warn("Cannot extract SAML assertion from the WS-Security SOAP header", (Throwable)e);
                return;
            }
            message.getExchange().put((Object)XUA_SAML_ASSERTION, (Object)assertion);
        }
        String userName = assertion.getSubject() != null && assertion.getSubject().getNameID() != null ? assertion.getSubject().getNameID().getValue() : null;
        String string = issuer = assertion.getIssuer() != null ? assertion.getIssuer().getValue() : null;
        if (StringUtils.isNotEmpty((CharSequence)issuer) && StringUtils.isNotEmpty((CharSequence)userName)) {
            auditDataset.setUserName(String.valueOf(assertion.getSubject().getNameID().getSPProvidedID()) + '<' + userName + '@' + issuer + '>');
        }
        for (AttributeStatement statement : assertion.getAttributeStatements()) {
            for (Attribute attribute : statement.getAttributes()) {
                if (!"urn:oasis:names:tc:xspa:1.0:subject:purposeofuse".equals(attribute.getName())) continue;
                for (XMLObject value : attribute.getAttributeValues()) {
                    NodeList purposeElemList = value.getDOM().getElementsByTagNameNS("urn:hl7-org:v3", "PurposeOfUse");
                    int i = 0;
                    while (i < purposeElemList.getLength()) {
                        Element purposeElem = (Element)purposeElemList.item(i);
                        CodedValueType cvt = new CodedValueType();
                        cvt.setCode(purposeElem.getAttribute("code"));
                        cvt.setCodeSystemName(purposeElem.getAttribute("codeSystem"));
                        cvt.setOriginalText(purposeElem.getAttribute("displayName"));
                        auditDataset.getPurposesOfUse().add(cvt);
                        ++i;
                    }
                }
            }
        }
    }

    protected static void extractAddressesFromServletRequest(SoapMessage message, WsAuditDataset auditDataset) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        auditDataset.setClientIpAddress(request.getRemoteAddr());
        auditDataset.setServiceEndpointUrl(request.getRequestURL().toString());
    }

    protected static Object extractPojo(Message message) {
        List list = (List)message.getContent(List.class);
        return list == null || list.isEmpty() ? null : list.get(0);
    }
}

