/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutStreamSubstituteInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.WrappedOutputStream;
import org.openehealth.ipf.commons.ihe.ws.utils.SoapUtils;

public class OutPayloadExtractorInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String PAYLOAD_COLLECTING_DEACTIVATION_ENABLED = String.valueOf(OutPayloadExtractorInterceptor.class.getName()) + ".collecting.deactivation.enabled";

    public OutPayloadExtractorInterceptor() {
        super("write-ending");
        this.addAfter(SoapOutInterceptor.SoapOutEndingInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            return;
        }
        WrappedOutputStream wrapper = OutStreamSubstituteInterceptor.getStreamWrapper(message);
        if (!Boolean.FALSE.equals(message.getContextualProperty(PAYLOAD_COLLECTING_DEACTIVATION_ENABLED))) {
            wrapper.deactivate();
        }
        String soapEnvelope = wrapper.getCollectedPayload();
        String payload = SoapUtils.extractSoapBody(soapEnvelope);
        StringPayloadHolder payloadHolder = new StringPayloadHolder();
        payloadHolder.put(StringPayloadHolder.PayloadType.SOAP_BODY, payload);
        message.setContent(StringPayloadHolder.class, (Object)payloadHolder);
    }
}

