/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SoapUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(SoapUtils.class);
    public static final Set<String> WS_ADDRESSING_NS_URIS = new HashSet<String>();
    public static final Set<String> SOAP_NS_URIS;

    static {
        WS_ADDRESSING_NS_URIS.add("http://www.w3.org/2005/08/addressing");
        WS_ADDRESSING_NS_URIS.add("http://schemas.xmlsoap.org/ws/2004/03/addressing");
        WS_ADDRESSING_NS_URIS.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        SOAP_NS_URIS = new HashSet<String>();
        SOAP_NS_URIS.add("http://schemas.xmlsoap.org/soap/envelope/");
        SOAP_NS_URIS.add("http://www.w3.org/2003/05/soap-envelope");
    }

    private SoapUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static Element getElementNS(Element root, Set<String> nsUris, String wantedLocalName) {
        if (root == null) {
            return null;
        }
        Node node = root.getFirstChild();
        while (node != null) {
            if (node instanceof Element && nsUris.contains(node.getNamespaceURI()) && node.getLocalName().equals(wantedLocalName)) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String extractSoapBody(String soapEnvelope) {
        int pos5;
        int pos1;
        block3: {
            try {
                pos1 = soapEnvelope.lastIndexOf("<");
                pos1 = soapEnvelope.lastIndexOf("<", pos1 - 1);
                pos5 = soapEnvelope.indexOf(">", pos1);
                if (soapEnvelope.charAt(pos5 - 1) != '/') break block3;
                return "";
            }
            catch (Exception e) {
                LOG.error("Invalid contents, probably not a SOAP Envelope in the parameter", (Throwable)e);
                return soapEnvelope;
            }
        }
        int pos2 = soapEnvelope.indexOf(":", pos1);
        String soapPrefix = pos2 == -1 || pos5 < pos2 ? "" : soapEnvelope.substring(pos1 + 2, pos2 + 1);
        String bodyElementStart = "<" + soapPrefix + "Body";
        int pos3 = soapEnvelope.indexOf(bodyElementStart);
        int pos4 = soapEnvelope.indexOf(62, pos3 + bodyElementStart.length());
        return soapEnvelope.substring(pos4 + 1, pos1);
    }

    public static String extractNonEmptyElement(String document, String elementName) {
        int pos3;
        int pos1;
        block8: {
            int pos2;
            block7: {
                block6: {
                    try {
                        pos1 = document.lastIndexOf(String.valueOf(elementName) + '>');
                        if (pos1 >= 0) break block6;
                        LOG.warn("Cannot find end of the closing tag of {}", (Object)elementName);
                        return null;
                    }
                    catch (Exception e) {
                        LOG.error("Could not extract element" + elementName, (Throwable)e);
                        return null;
                    }
                }
                pos2 = document.lastIndexOf(60, pos1 - 1);
                if (pos2 >= 0) break block7;
                LOG.warn("Cannot find start of the closing tag of {}", (Object)elementName);
                return null;
            }
            StringBuilder sb = new StringBuilder().append('<');
            if (pos1 - pos2 > 2) {
                sb.append(document, pos2 + 2, pos1 - 1).append(':');
            }
            if ((pos3 = document.indexOf(sb.append(elementName).toString())) >= 0) break block8;
            LOG.warn("Cannot find start of the opening tag of {}", (Object)elementName);
            return null;
        }
        return document.substring(pos3, pos1 + elementName.length() + 1);
    }

    public static Exception extractOutgoingException(Exchange exchange) {
        Message outFaultMessage = exchange.getOutFaultMessage();
        return outFaultMessage != null ? (Exception)outFaultMessage.getContent(Exception.class) : null;
    }

    public static String extractOutgoingPayload(Exchange exchange) {
        try {
            return (String)((List)exchange.getOutMessage().getContent(List.class)).get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

