/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf;

import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;

public class ProvidedAttachmentOutInterceptor
extends AbstractSoapInterceptor {
    public static final String ATTACHMENTS = ProvidedAttachmentOutInterceptor.class.getName() + ".provided_attachments";

    public ProvidedAttachmentOutInterceptor() {
        super("pre-logical");
        this.addAfter(HolderOutInterceptor.class.getName());
        this.addBefore(WrapperClassOutInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Map providedAttachments = (Map)message.getContextualProperty(ATTACHMENTS);
        if (providedAttachments.isEmpty()) {
            return;
        }
        ArrayList<AttachmentImpl> attachments = message.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<AttachmentImpl>();
            message.setAttachments(attachments);
        }
        for (Map.Entry entry : providedAttachments.entrySet()) {
            attachments.add(new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue()));
        }
        message.put("write.attachments", (Object)Boolean.TRUE);
    }
}

