/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class AuditOutRequestInterceptor<T extends WsAuditDataset>
extends AbstractAuditInterceptor<T> {
    private final AsynchronyCorrelator<T> correlator;
    private final WsTransactionConfiguration<T> wsTransactionConfiguration;

    public AuditOutRequestInterceptor(AuditStrategy<T> auditStrategy, AuditContext auditContext, AsynchronyCorrelator<T> correlator, WsTransactionConfiguration<T> wsTransactionConfiguration) {
        super("pre-protocol-ending", auditStrategy, auditContext);
        this.addAfter(OutPayloadExtractorInterceptor.class.getName());
        this.correlator = correlator;
        this.wsTransactionConfiguration = wsTransactionConfiguration;
    }

    @Override
    protected void process(SoapMessage message) {
        if (this.isGET((Message)message)) {
            return;
        }
        Object auditDataset = this.getAuditDataset(message);
        ((WsAuditDataset)((Object)auditDataset)).setRemoteAddress((String)message.get((Object)Message.ENDPOINT_ADDRESS));
        ((WsAuditDataset)((Object)auditDataset)).setDestinationUserId((String)message.get((Object)Message.ENDPOINT_ADDRESS));
        AuditOutRequestInterceptor.enrichAuditDatasetFromXuaToken(message, Header.Direction.DIRECTION_OUT, auditDataset);
        Object request = AuditOutRequestInterceptor.extractPojo((Message)message);
        if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
            if (request instanceof String) {
                ((WsAuditDataset)((Object)auditDataset)).setRequestPayload((String)request);
            } else {
                ((WsAuditDataset)((Object)auditDataset)).setRequestPayload((StringPayloadHolder)message.getContent(StringPayloadHolder.class));
            }
        }
        this.getAuditStrategy().enrichAuditDatasetFromRequest(auditDataset, request, (Map)message);
        AddressingProperties props = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (props != null && (Boolean.TRUE.equals(message.getContextualProperty(AsynchronyCorrelator.FORCE_CORRELATION)) || !"http://www.w3.org/2005/08/addressing/anonymous".equals(props.getReplyTo().getAddress().getValue()))) {
            this.correlator.storeAuditDataset(props.getMessageID().getValue(), (WsAuditDataset)((Object)auditDataset));
        }
    }
}

