/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.soap.SoapBindingConfiguration;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.InterceptorUtils;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.cxf.Cxf3791WorkaroundInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.RejectionHandlerInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.WsRejectionHandlingStrategy;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.InPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class JaxWsServiceFactory<AuditDatasetType extends WsAuditDataset> {
    protected final WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration;
    protected final String serviceAddress;
    protected final InterceptorProvider customInterceptors;
    protected final WsRejectionHandlingStrategy rejectionHandlingStrategy;
    protected final AuditStrategy<AuditDatasetType> auditStrategy;
    protected final AuditContext auditContext;

    public JaxWsServiceFactory(WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration, String serviceAddress, AuditStrategy<AuditDatasetType> auditStrategy, AuditContext auditContext, InterceptorProvider customInterceptors, WsRejectionHandlingStrategy rejectionHandlingStrategy) {
        this.wsTransactionConfiguration = wsTransactionConfiguration;
        this.serviceAddress = serviceAddress;
        this.auditStrategy = auditStrategy;
        this.auditContext = auditContext;
        this.customInterceptors = customInterceptors;
        this.rejectionHandlingStrategy = rejectionHandlingStrategy;
    }

    public ServerFactoryBean createServerFactory(Class<?> serviceImplClass) {
        try {
            return this.createServerFactory(serviceImplClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public ServerFactoryBean createServerFactory(Object serviceImpl) {
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        this.configureService((ServerFactoryBean)svrFactory, serviceImpl);
        this.configureBinding((ServerFactoryBean)svrFactory);
        this.configureInterceptors((ServerFactoryBean)svrFactory);
        svrFactory.setStart(false);
        return svrFactory;
    }

    private void configureService(ServerFactoryBean svrFactory, Object service) {
        svrFactory.setServiceClass(this.wsTransactionConfiguration.getSei());
        svrFactory.setServiceName(this.wsTransactionConfiguration.getServiceName());
        svrFactory.setWsdlLocation(this.wsTransactionConfiguration.getWsdlLocation());
        svrFactory.setAddress(this.serviceAddress);
        svrFactory.setServiceBean(service);
        svrFactory.getFeatures().add(new WSAddressingFeature());
        if (this.wsTransactionConfiguration.isMtom()) {
            svrFactory.setProperties(Collections.singletonMap("mtom-enabled", "true"));
        }
    }

    private void configureBinding(ServerFactoryBean svrFactory) {
        SoapBindingConfiguration bindingConfig = new SoapBindingConfiguration();
        bindingConfig.setBindingName(this.wsTransactionConfiguration.getBindingName());
        svrFactory.setBindingConfig((BindingConfiguration)bindingConfig);
    }

    protected void configureInterceptors(ServerFactoryBean svrFactory) {
        svrFactory.getInInterceptors().add(new Cxf3791WorkaroundInterceptor());
        InterceptorUtils.copyInterceptorsFromProvider(this.customInterceptors, (InterceptorProvider)svrFactory);
        if (this.rejectionHandlingStrategy != null) {
            svrFactory.getInInterceptors().add(new InPayloadExtractorInterceptor(StringPayloadHolder.PayloadType.HTTP));
            RejectionHandlerInterceptor rejectionHandlerInterceptor = new RejectionHandlerInterceptor(this.rejectionHandlingStrategy);
            svrFactory.getOutInterceptors().add(rejectionHandlerInterceptor);
            svrFactory.getOutFaultInterceptors().add(rejectionHandlerInterceptor);
        }
    }
}

