/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.openehealth.ipf.commons.ihe.core.payload.PayloadLoggerBase;
import org.openehealth.ipf.commons.ihe.core.payload.PayloadLoggingContext;
import org.openehealth.ipf.commons.ihe.ws.InterceptorUtils;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.OutStreamSubstituteInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.WrappedOutputStream;

public class WsPayloadLoggerBase
extends PayloadLoggerBase<WsPayloadLoggingContext> {
    public void logPayload(Message message) {
        Long sequenceId = (Long)InterceptorUtils.findContextualProperty(message, SEQUENCE_ID_PROPERTY_NAME);
        if (sequenceId == null) {
            sequenceId = WsPayloadLoggerBase.getNextSequenceId();
            message.getExchange().put((Object)SEQUENCE_ID_PROPERTY_NAME, (Object)sequenceId);
        }
        WsPayloadLoggingContext spelContext = new WsPayloadLoggingContext(sequenceId, WsPayloadLoggerBase.getInteractionId(message), Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.partial.response")));
        boolean isOutbound = MessageUtils.isOutbound((Message)message);
        this.doLogPayload(spelContext, (String)message.get((Object)Message.ENCODING), new String[]{isOutbound ? WsPayloadLoggerBase.getOutboundMetadataPayload(message) : WsPayloadLoggerBase.getInboundMetadataPayload(message), WsPayloadLoggerBase.getHeadersPayload(message), isOutbound ? WsPayloadLoggerBase.getOutboundBodyPayload(message) : WsPayloadLoggerBase.getInboundBodyPayload(message)});
    }

    private static String getHeadersPayload(Message message) {
        StringBuilder sb = new StringBuilder();
        Object encoding = message.get((Object)Message.ENCODING);
        if (encoding != null) {
            sb.append("Character set: ").append(encoding).append('\n');
        }
        sb.append('\n');
        Map httpHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (httpHeaders != null) {
            for (Map.Entry entry : httpHeaders.entrySet()) {
                for (String header : (List)entry.getValue()) {
                    sb.append((String)entry.getKey()).append(": ").append(header).append('\n');
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String getInboundMetadataPayload(Message message) {
        StringBuilder sb = new StringBuilder();
        if (Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"))) {
            sb.append("HTTP response code: ").append(message.get((Object)Message.RESPONSE_CODE)).append('\n');
        } else {
            sb.append("HTTP request: ").append(message.get((Object)"org.apache.cxf.request.method")).append(' ').append(message.get((Object)"org.apache.cxf.request.url")).append('\n');
        }
        return sb.toString();
    }

    private static String getInboundBodyPayload(Message message) {
        StringPayloadHolder payloadHolder = (StringPayloadHolder)message.getContent(StringPayloadHolder.class);
        return payloadHolder != null ? payloadHolder.get(StringPayloadHolder.PayloadType.HTTP) : "";
    }

    private static String getOutboundMetadataPayload(Message message) {
        StringBuilder sb = new StringBuilder();
        Object endpointAddress = message.get((Object)Message.ENDPOINT_ADDRESS);
        if (endpointAddress != null) {
            sb.append("Target endpoint: ").append(endpointAddress).append('\n');
        } else {
            HttpServletResponse response = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            sb.append("HTTP response code: ").append(response != null ? Integer.valueOf(response.getStatus()) : "unknown").append('\n');
        }
        return sb.toString();
    }

    private static String getOutboundBodyPayload(Message message) {
        WrappedOutputStream wrapper = OutStreamSubstituteInterceptor.getStreamWrapper(message);
        wrapper.deactivate();
        return wrapper.getCollectedPayload();
    }

    private static String getInteractionId(Message message) {
        Class seiClass = (Class)message.getContextualProperty("endpoint.class");
        String name = seiClass.getSimpleName();
        return name.endsWith("PortType") ? name.substring(0, name.length() - 8) : name;
    }

    static class WsPayloadLoggingContext
    extends PayloadLoggingContext {
        private final boolean partialResponse;

        WsPayloadLoggingContext(long sequenceId, String interactionId, boolean partialResponse) {
            super(Long.valueOf(sequenceId), interactionId);
            this.partialResponse = partialResponse;
        }

        public boolean isPartialResponse() {
            return this.partialResponse;
        }
    }
}

