/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit;

import java.util.List;
import java.util.Map;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditStrategy;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsQueryAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLAdhocQueryRequest30;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.AdhocQueryType;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public abstract class XdsQueryAuditStrategy30
extends XdsAuditStrategy<XdsQueryAuditDataset> {
    public XdsQueryAuditStrategy30(boolean serverSide) {
        super(serverSide);
    }

    public XdsQueryAuditDataset enrichAuditDatasetFromRequest(XdsQueryAuditDataset auditDataset, Object pojo, Map<String, Object> parameters) {
        if (pojo instanceof AdhocQueryRequest) {
            QuerySlotHelper slotHelper;
            List<String> patientIdList;
            AdhocQueryRequest request = (AdhocQueryRequest)pojo;
            AdhocQueryType adHocQuery = request.getAdhocQuery();
            if (adHocQuery != null) {
                auditDataset.setQueryUuid(adHocQuery.getId());
                auditDataset.setHomeCommunityId(adHocQuery.getHome());
            }
            if ((patientIdList = (slotHelper = new QuerySlotHelper(new EbXMLAdhocQueryRequest30(request))).toStringList(QueryParameter.DOC_ENTRY_PATIENT_ID)) != null) {
                auditDataset.getPatientIds().addAll(patientIdList);
            }
        }
        return auditDataset;
    }

    public XdsQueryAuditDataset createAuditDataset() {
        return new XdsQueryAuditDataset(this.isServerSide());
    }
}

