/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit.event;

import java.util.Collections;
import java.util.stream.IntStream;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.event.PHIImportBuilder;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsNonconstructiveDocumentSetRequestAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsSubmitAuditDataset;

public class XdsPHIImportBuilder
extends PHIImportBuilder<XdsPHIImportBuilder> {
    public XdsPHIImportBuilder(AuditContext auditContext, XdsAuditDataset auditDataset, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(auditContext, auditDataset, EventActionCode.Create, eventType, purposesOfUse);
    }

    public XdsPHIImportBuilder(AuditContext auditContext, XdsAuditDataset auditDataset, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, (AuditDataset)auditDataset, eventActionCode, eventType, purposesOfUse);
    }

    public XdsPHIImportBuilder(AuditContext auditContext, AuditDataset auditDataset, EventOutcomeIndicator eventOutcomeIndicator, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, auditDataset, eventOutcomeIndicator, eventOutcomeDescription, eventActionCode, eventType, purposesOfUse);
    }

    public XdsPHIImportBuilder setSubmissionSet(XdsSubmitAuditDataset auditDataset) {
        return (XdsPHIImportBuilder)this.addImportedEntity(auditDataset.getSubmissionSetUuid(), (ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, ParticipantObjectTypeCodeRole.Job, Collections.emptyList());
    }

    public XdsPHIImportBuilder setSubmissionSetWithHomeCommunityId(XdsSubmitAuditDataset auditDataset, boolean xcaHomeCommunityId) {
        return (XdsPHIImportBuilder)this.addImportedEntity(auditDataset.getSubmissionSetUuid(), (ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, ParticipantObjectTypeCodeRole.Job, this.documentDetails(null, auditDataset.getHomeCommunityId(), null, null, xcaHomeCommunityId));
    }

    public XdsPHIImportBuilder addDocumentIds(XdsNonconstructiveDocumentSetRequestAuditDataset auditDataset, XdsNonconstructiveDocumentSetRequestAuditDataset.Status status, boolean xcaHomeCommunityId) {
        String[] documentIds = auditDataset.getDocumentIds(status);
        String[] homeCommunityIds = auditDataset.getHomeCommunityIds(status);
        String[] repositoryIds = auditDataset.getRepositoryIds(status);
        String[] seriesInstanceIds = auditDataset.getSeriesInstanceIds(status);
        String[] studyInstanceIds = auditDataset.getStudyInstanceIds(status);
        IntStream.range(0, documentIds.length).forEach(i -> {
            XdsPHIImportBuilder cfr_ignored_0 = (XdsPHIImportBuilder)this.addImportedEntity(documentIds[i], (ParticipantObjectIdType)ParticipantObjectIdTypeCode.ReportNumber, ParticipantObjectTypeCodeRole.Report, this.documentDetails(repositoryIds[i], homeCommunityIds[i], seriesInstanceIds[i], studyInstanceIds[i], xcaHomeCommunityId));
        });
        return (XdsPHIImportBuilder)this.self();
    }

    protected String getRemoteAltUserId() {
        return this.getAuditContext().getAuditValueIfMissing();
    }
}

