/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit.event;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.event.PatientRecordBuilder;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.event.PatientRecordEventBuilder;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsNonconstructiveDocumentSetRequestAuditDataset;

public class XdsPatientRecordEventBuilder
extends PatientRecordEventBuilder<XdsPatientRecordEventBuilder> {
    public XdsPatientRecordEventBuilder(AuditContext auditContext, XdsAuditDataset auditDataset, EventActionCode action, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, (AuditDataset)auditDataset, action, eventType, purposesOfUse);
    }

    public XdsPatientRecordEventBuilder(AuditContext auditContext, XdsAuditDataset auditDataset, EventOutcomeIndicator eventOutcomeIndicator, String eventOutcomeDescription, EventActionCode action, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, (AuditDataset)auditDataset, eventOutcomeIndicator, eventOutcomeDescription, action, eventType, purposesOfUse);
    }

    public XdsPatientRecordEventBuilder addPatients(List<String> patientIds) {
        return (XdsPatientRecordEventBuilder)this.addPatients(null, null, patientIds.toArray(new String[0]));
    }

    public XdsPatientRecordEventBuilder addObjectIds(List<String> objectIds, ParticipantObjectDataLifeCycle lifeCycle) {
        if (objectIds != null) {
            objectIds.forEach(objectId -> {
                PatientRecordBuilder cfr_ignored_0 = (PatientRecordBuilder)((PatientRecordBuilder)this.delegate).addParticipantObjectIdentification(ParticipantObjectIdType.of((String)"urn:ihe:iti:2017:ObjectRef", (String)"IHE XDS Metadata", (String)"registry object reference"), null, null, Collections.emptyList(), objectId, ParticipantObjectTypeCode.System, ParticipantObjectTypeCodeRole.Report, lifeCycle, null);
            });
        }
        return (XdsPatientRecordEventBuilder)this.self();
    }

    public XdsPatientRecordEventBuilder addDocumentIds(XdsNonconstructiveDocumentSetRequestAuditDataset auditDataset, XdsNonconstructiveDocumentSetRequestAuditDataset.Status status, ParticipantObjectIdType participantObjectIdType, ParticipantObjectDataLifeCycle lifeCycle) {
        String[] documentIds = auditDataset.getDocumentIds(status);
        String[] repositoryIds = auditDataset.getRepositoryIds(status);
        IntStream.range(0, documentIds.length).forEach(i -> {
            PatientRecordBuilder cfr_ignored_0 = (PatientRecordBuilder)((PatientRecordBuilder)this.delegate).addParticipantObjectIdentification(participantObjectIdType, null, null, this.makeDetail((PatientRecordBuilder)this.delegate, repositoryIds[i]), documentIds[i], ParticipantObjectTypeCode.System, ParticipantObjectTypeCodeRole.Report, lifeCycle, null);
        });
        return (XdsPatientRecordEventBuilder)this.self();
    }

    private List<TypeValuePairType> makeDetail(PatientRecordBuilder builder, String repositoryId) {
        return repositoryId != null && !repositoryId.isEmpty() ? Collections.singletonList(((PatientRecordBuilder)this.delegate).getTypeValuePair("Repository Unique Id", (Object)repositoryId)) : Collections.emptyList();
    }
}

