/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="Address", propOrder={"streetAddress", "otherDesignation", "city", "countyParishCode", "stateOrProvince", "country", "zipOrPostalCode"})
public class Address
extends Hl7v2Based<XAD> {
    private static final long serialVersionUID = -5050715144917393181L;

    public Address() {
        super(new XAD(MESSAGE));
    }

    public Address(XAD xad) {
        super(xad);
    }

    public String getStreetAddress() {
        return ((XAD)this.getHapiObject()).getXad1_StreetAddress().getSad1_StreetOrMailingAddress().getValue();
    }

    public void setStreetAddress(String streetAddress) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad1_StreetAddress().getSad1_StreetOrMailingAddress(), streetAddress);
    }

    @XmlElement(name="additionalLocator")
    public String getOtherDesignation() {
        return ((XAD)this.getHapiObject()).getXad2_OtherDesignation().getValue();
    }

    public void setOtherDesignation(String otherDesignation) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad2_OtherDesignation(), otherDesignation);
    }

    public String getCity() {
        return ((XAD)this.getHapiObject()).getXad3_City().getValue();
    }

    public void setCity(String city) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad3_City(), city);
    }

    @XmlElement(name="state")
    public String getStateOrProvince() {
        return ((XAD)this.getHapiObject()).getXad4_StateOrProvince().getValue();
    }

    public void setStateOrProvince(String stateOrProvince) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad4_StateOrProvince(), stateOrProvince);
    }

    @XmlElement(name="postalCode")
    public String getZipOrPostalCode() {
        return ((XAD)this.getHapiObject()).getXad5_ZipOrPostalCode().getValue();
    }

    public void setZipOrPostalCode(String zipOrPostalCode) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad5_ZipOrPostalCode(), zipOrPostalCode);
    }

    public String getCountry() {
        return ((XAD)this.getHapiObject()).getXad6_Country().getValue();
    }

    public void setCountry(String country) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad6_Country(), country);
    }

    @XmlElement(name="county")
    public String getCountyParishCode() {
        return ((XAD)this.getHapiObject()).getXad9_CountyParishCode().getValue();
    }

    public void setCountyParishCode(String countyParishCode) {
        Address.setValue((Primitive)((XAD)this.getHapiObject()).getXad9_CountyParishCode(), countyParishCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address that = (Address)o;
        return Objects.equals(this.getCity(), that.getCity()) && Objects.equals(this.getCountry(), that.getCountry()) && Objects.equals(this.getCountyParishCode(), that.getCountyParishCode()) && Objects.equals(this.getOtherDesignation(), that.getOtherDesignation()) && Objects.equals(this.getStateOrProvince(), that.getStateOrProvince()) && Objects.equals(this.getStreetAddress(), that.getStreetAddress()) && Objects.equals(this.getZipOrPostalCode(), that.getZipOrPostalCode());
    }

    public int hashCode() {
        return Objects.hash(this.getCity(), this.getCountry(), this.getCountyParishCode(), this.getOtherDesignation(), this.getStateOrProvince(), this.getStreetAddress(), this.getZipOrPostalCode());
    }

    public String toString() {
        return "Address(streetAddress=" + this.getStreetAddress() + ", otherDesignation=" + this.getOtherDesignation() + ", city=" + this.getCity() + ", stateOrProvince=" + this.getStateOrProvince() + ", zipOrPostalCode=" + this.getZipOrPostalCode() + ", country=" + this.getCountry() + ", countyParishCode=" + this.getCountyParishCode() + ')';
    }
}

