/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlType(name="DocumentEntryType")
@XmlEnum(value=String.class)
public enum DocumentEntryType {
    STABLE("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1"),
    ON_DEMAND("urn:uuid:34268e47-fdf5-41a6-ba33-82133c465248");

    public static final String[] STABLE_OR_ON_DEMAND;
    private final String uuid;

    private DocumentEntryType(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static String toUuid(DocumentEntryType type) {
        return type != null ? type.uuid : null;
    }

    public static DocumentEntryType valueOfUuid(String uuid) {
        for (DocumentEntryType type : DocumentEntryType.values()) {
            if (!type.uuid.equals(uuid)) continue;
            return type;
        }
        throw new XDSMetaDataException(ValidationMessage.WRONG_DOCUMENT_ENTRY_TYPE, uuid);
    }

    static {
        STABLE_OR_ON_DEMAND = new String[]{STABLE.getUuid(), ON_DEMAND.getUuid()};
    }
}

