/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Composite;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XcnName;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XpnName;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters.NameAdapter;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlJavaTypeAdapter(value=NameAdapter.class)
@XmlType(name="Name", propOrder={"prefix", "givenName", "secondAndFurtherGivenNames", "familyName", "suffix", "degree"})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
public abstract class Name<T extends Composite>
extends Hl7v2Based<T> {
    private static final long serialVersionUID = -3455779057944896901L;
    @JsonProperty
    private String type;

    public Name() {
    }

    protected Name(T hapiObject) {
        super(hapiObject);
    }

    @JsonCreator
    private static Name createInstance(String type, String family, String given, String secondAndFurtherGiven, String suffix, String prefix, String degree) {
        if (XcnName.class.getName().equals(type)) {
            return new XcnName(family, given, secondAndFurtherGiven, suffix, prefix, degree);
        }
        if (XpnName.class.getName().equals(type)) {
            return new XpnName(family, given, secondAndFurtherGiven, suffix, prefix, degree);
        }
        throw new ExceptionInInitializerError("Unknown name type " + type);
    }

    @XmlElement(name="family")
    public abstract String getFamilyName();

    @XmlElement(name="given")
    public abstract String getGivenName();

    @XmlElement(name="secondAndFurtherGiven")
    public abstract String getSecondAndFurtherGivenNames();

    public abstract String getSuffix();

    public abstract String getPrefix();

    public abstract String getDegree();

    public abstract void setFamilyName(String var1);

    public abstract void setGivenName(String var1);

    public abstract void setSecondAndFurtherGivenNames(String var1);

    public abstract void setSuffix(String var1);

    public abstract void setPrefix(String var1);

    public abstract void setDegree(String var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name that = (Name)o;
        return Objects.equals(this.getFamilyName(), that.getFamilyName()) && Objects.equals(this.getGivenName(), that.getGivenName()) && Objects.equals(this.getSecondAndFurtherGivenNames(), that.getSecondAndFurtherGivenNames()) && Objects.equals(this.getSuffix(), that.getSuffix()) && Objects.equals(this.getPrefix(), that.getPrefix()) && Objects.equals(this.getDegree(), that.getDegree());
    }

    public int hashCode() {
        return Objects.hash(this.getFamilyName(), this.getGivenName(), this.getSecondAndFurtherGivenNames(), this.getSuffix(), this.getPrefix(), this.getDegree());
    }

    public String toString() {
        return "Name(familyName=" + this.getFamilyName() + ", givenName=" + this.getGivenName() + ", secondAndFurtherGivenNames=" + this.getSecondAndFurtherGivenNames() + ", suffix=" + this.getSuffix() + ", prefix=" + this.getPrefix() + ", degree=" + this.getDegree() + ')';
    }
}

