/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="Organization", propOrder={"idNumber", "assigningAuthority", "organizationName"})
public class Organization
extends Hl7v2Based<XON> {
    private static final long serialVersionUID = 8283797476558181158L;

    public Organization() {
        super(new XON(MESSAGE));
    }

    public Organization(XON xon) {
        super(xon);
    }

    public Organization(String organizationName) {
        this();
        this.setOrganizationName(organizationName);
    }

    public Organization(String organizationName, String idNumber, AssigningAuthority assigningAuthority) {
        this();
        this.setOrganizationName(organizationName);
        this.setIdNumber(idNumber);
        this.setAssigningAuthority(assigningAuthority);
    }

    public AssigningAuthority getAssigningAuthority() {
        AssigningAuthority authority = new AssigningAuthority(((XON)this.getHapiObject()).getXon6_AssigningAuthority());
        return authority.isEmpty() ? null : authority;
    }

    public void setAssigningAuthority(AssigningAuthority assigningAuthority) {
        Organization.setAssigningAuthority(assigningAuthority, ((XON)this.getHapiObject()).getXon6_AssigningAuthority());
    }

    @XmlElement(name="name")
    public String getOrganizationName() {
        return ((XON)this.getHapiObject()).getXon1_OrganizationName().getValue();
    }

    public void setOrganizationName(String organizationName) {
        Organization.setValue((Primitive)((XON)this.getHapiObject()).getXon1_OrganizationName(), organizationName);
    }

    public String getIdNumber() {
        return ((XON)this.getHapiObject()).getXon10_OrganizationIdentifier().getValue();
    }

    public void setIdNumber(String idNumber) {
        Organization.setValue((Primitive)((XON)this.getHapiObject()).getXon10_OrganizationIdentifier(), idNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization that = (Organization)o;
        return Objects.equals(this.getAssigningAuthority(), that.getAssigningAuthority()) && Objects.equals(this.getOrganizationName(), that.getOrganizationName()) && Objects.equals(this.getIdNumber(), that.getIdNumber());
    }

    public int hashCode() {
        return Objects.hash(this.getAssigningAuthority(), this.getOrganizationName(), this.getIdNumber());
    }

    public String toString() {
        return "Organization(assigningAuthority=" + this.getAssigningAuthority() + ", organizationName=" + this.getOrganizationName() + ", idNumber=" + this.getIdNumber() + ')';
    }
}

