/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="Telecom", propOrder={"use", "type", "email", "countryCode", "areaCityCode", "localNumber", "extension", "unformattedPhoneNumber"})
public class Telecom
extends Hl7v2Based<XTN> {
    private static final long serialVersionUID = 526836203236101658L;

    public Telecom() {
        super(new XTN(MESSAGE));
    }

    public Telecom(XTN xtn) {
        super(xtn);
    }

    @Deprecated
    public Telecom(String address, String addressType) {
        this();
        this.setAddress(address);
        this.setAddressType(addressType);
    }

    public Telecom(String email) {
        this();
        this.setUse("NET");
        this.setType("Internet");
        this.setEmail(email);
    }

    public Telecom(Long countryCode, Long areaCityCode, Long localNumber, Long extension) {
        this();
        this.setUse("PRN");
        this.setType("PH");
        this.setCountryCode(countryCode);
        this.setAreaCityCode(areaCityCode);
        this.setLocalNumber(localNumber);
        this.setExtension(extension);
    }

    public Telecom(Integer countryCode, Integer areaCityCode, Integer localNumber, Integer extension) {
        this(countryCode == null ? null : Long.valueOf(countryCode.longValue()), areaCityCode == null ? null : Long.valueOf(areaCityCode.longValue()), localNumber == null ? null : Long.valueOf(localNumber.longValue()), extension == null ? null : Long.valueOf(extension.longValue()));
    }

    @XmlElement(name="use")
    public String getUse() {
        return ((XTN)this.getHapiObject()).getXtn2_TelecommunicationUseCode().getValue();
    }

    public void setUse(String use) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn2_TelecommunicationUseCode(), use);
    }

    @XmlElement(name="type")
    public String getType() {
        return ((XTN)this.getHapiObject()).getXtn3_TelecommunicationEquipmentType().getValue();
    }

    public void setType(String type) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn3_TelecommunicationEquipmentType(), type);
    }

    @Deprecated
    @XmlTransient
    public String getAddressType() {
        return this.getType();
    }

    @Deprecated
    public void setAddressType(String addressType) {
        this.setType(addressType);
    }

    @XmlElement(name="email")
    public String getEmail() {
        return ((XTN)this.getHapiObject()).getXtn4_EmailAddress().getValue();
    }

    public void setEmail(String email) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn4_EmailAddress(), email);
    }

    @Deprecated
    @XmlTransient
    public String getAddress() {
        return this.getEmail();
    }

    @Deprecated
    public void setAddress(String address) {
        this.setEmail(address);
    }

    @XmlElement(name="countryCode")
    public Long getCountryCode() {
        return Telecom.getLongValue((Primitive)((XTN)this.getHapiObject()).getXtn5_CountryCode());
    }

    public void setCountryCode(Long countryCode) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn5_CountryCode(), countryCode == null ? null : countryCode.toString());
    }

    @XmlElement(name="areaCityCode")
    public Long getAreaCityCode() {
        return Telecom.getLongValue((Primitive)((XTN)this.getHapiObject()).getXtn6_AreaCityCode());
    }

    public void setAreaCityCode(Long areaCityCode) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn6_AreaCityCode(), areaCityCode == null ? null : areaCityCode.toString());
    }

    @XmlElement(name="localNumber")
    public Long getLocalNumber() {
        return Telecom.getLongValue((Primitive)((XTN)this.getHapiObject()).getXtn7_LocalNumber());
    }

    public void setLocalNumber(Long localNumber) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn7_LocalNumber(), localNumber == null ? null : localNumber.toString());
    }

    @XmlElement(name="extension")
    public Long getExtension() {
        return Telecom.getLongValue((Primitive)((XTN)this.getHapiObject()).getXtn8_Extension());
    }

    public void setExtension(Long extension) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn8_Extension(), extension == null ? null : extension.toString());
    }

    @XmlElement(name="unformattedPhoneNumber")
    public String getUnformattedPhoneNumber() {
        return ((XTN)this.getHapiObject()).getXtn12_UnformattedTelephoneNumber().getValue();
    }

    public void setUnformattedPhoneNumber(String unformattedPhoneNumber) {
        Telecom.setValue((Primitive)((XTN)this.getHapiObject()).getXtn12_UnformattedTelephoneNumber(), unformattedPhoneNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Telecom that = (Telecom)o;
        return Objects.equals(this.getUse(), that.getUse()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getEmail(), that.getEmail()) && Objects.equals(this.getCountryCode(), that.getCountryCode()) && Objects.equals(this.getAreaCityCode(), that.getAreaCityCode()) && Objects.equals(this.getLocalNumber(), that.getLocalNumber()) && Objects.equals(this.getExtension(), that.getExtension()) && Objects.equals(this.getUnformattedPhoneNumber(), that.getUnformattedPhoneNumber());
    }

    public int hashCode() {
        return Objects.hash(this.getUse(), this.getType(), this.getEmail(), this.getCountryCode(), this.getAreaCityCode(), this.getLocalNumber(), this.getExtension(), this.getUnformattedPhoneNumber());
    }

    public String toString() {
        return "Telecom(use=" + this.getUse() + ", type=" + this.getType() + ", email=" + this.getEmail() + ", countryCode=" + this.getCountryCode() + ", areaCityCode=" + this.getAreaCityCode() + ", localNumber=" + this.getLocalNumber() + ", extension=" + this.getExtension() + ", unformattedPhoneNumber=" + this.getUnformattedPhoneNumber() + ')';
    }
}

