/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.primitive.CommonTS;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters.DateTimeAdapter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Timestamp", propOrder={"dateTime", "precision"})
public class Timestamp
implements Serializable {
    private static final long serialVersionUID = 4324651691599629794L;
    private static final Map<Precision, DateTimeFormatter> FORMATTERS = new EnumMap<Precision, DateTimeFormatter>(Precision.class);
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private DateTime dateTime;
    @XmlAttribute
    private Precision precision;

    public Timestamp() {
    }

    public Timestamp(DateTime dateTime, Precision precision) {
        this.setDateTime(dateTime);
        this.setPrecision(precision);
    }

    public static Timestamp fromHL7(String s) {
        int len;
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        int pos = Math.max(s.indexOf(45), s.indexOf(43));
        int n = len = pos >= 0 ? pos : s.length();
        Precision precision = len >= 14 ? Precision.SECOND : (len >= 12 ? Precision.MINUTE : (len >= 10 ? Precision.HOUR : (len >= 8 ? Precision.DAY : (len >= 6 ? Precision.MONTH : Precision.YEAR))));
        if (pos < 0) {
            s = s + "+0000";
        }
        try {
            CommonTS ts = new CommonTS(s);
            DateTime dateTime = new DateTime(ts.getYear(), ts.getMonth() == 0 ? 1 : ts.getMonth(), ts.getDay() == 0 ? 1 : ts.getDay(), ts.getHour(), ts.getMinute(), ts.getSecond(), DateTimeZone.forOffsetHoursMinutes((int)(ts.getGMTOffset() / 100), (int)(ts.getGMTOffset() % 100)));
            return new Timestamp(dateTime.toDateTime(DateTimeZone.UTC), precision);
        }
        catch (DataTypeException e) {
            throw new XDSMetaDataException(ValidationMessage.INVALID_TIME, s);
        }
    }

    public static String toHL7(Timestamp timestamp) {
        return timestamp != null ? timestamp.toHL7() : null;
    }

    private String toHL7() {
        return FORMATTERS.get((Object)this.getPrecision()).print((ReadableInstant)this.getDateTime().toDateTime(DateTimeZone.UTC));
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime != null ? dateTime.toDateTime(DateTimeZone.UTC) : null;
    }

    public Precision getPrecision() {
        return this.precision != null ? this.precision : Precision.SECOND;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp timestamp = (Timestamp)o;
        return StringUtils.equals((CharSequence)Timestamp.toHL7(this), (CharSequence)Timestamp.toHL7(timestamp));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateTime, this.precision});
    }

    public String toString() {
        return "Timestamp(dateTime=" + this.dateTime + ", precision=" + (Object)((Object)this.precision) + ')';
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    static {
        FORMATTERS.put(Precision.YEAR, DateTimeFormat.forPattern((String)"yyyy"));
        FORMATTERS.put(Precision.MONTH, DateTimeFormat.forPattern((String)"yyyyMM"));
        FORMATTERS.put(Precision.DAY, DateTimeFormat.forPattern((String)"yyyyMMdd"));
        FORMATTERS.put(Precision.HOUR, DateTimeFormat.forPattern((String)"yyyyMMddHH"));
        FORMATTERS.put(Precision.MINUTE, DateTimeFormat.forPattern((String)"yyyyMMddHHmm"));
        FORMATTERS.put(Precision.SECOND, DateTimeFormat.forPattern((String)"yyyyMMddHHmmss"));
    }

    @XmlEnum
    @XmlType(name="Precision", namespace="http://www.openehealth.org/ipf/xds")
    public static enum Precision {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

