/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.requests.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.ListOfListAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QueryList")
public class QueryList<T>
implements Serializable {
    private static final long serialVersionUID = -2729640243221349924L;
    @XmlJavaTypeAdapter(value=ListOfListAdapter.class)
    @JsonIgnore
    private List<List<T>> outerList = new ArrayList<List<T>>();

    @JsonProperty
    private List<List<T>> getList() {
        return this.outerList;
    }

    private void setList(List<List<T>> list) {
        this.outerList = list;
    }

    public QueryList() {
    }

    public QueryList(QueryList<T> other) {
        Validate.notNull(other, (String)"other cannot be null", (Object[])new Object[0]);
        Validate.noNullElements(other.getOuterList(), (String)"other.getOuterList() cannot contain null elements", (Object[])new Object[0]);
        for (List<T> innerList : other.getOuterList()) {
            Validate.noNullElements(innerList, (String)"innerList cannot contain null elements", (Object[])new Object[0]);
            this.outerList.add(new ArrayList<T>(innerList));
        }
    }

    public QueryList(T singleElement) {
        Validate.notNull(singleElement, (String)"singleElement cannot be null", (Object[])new Object[0]);
        this.outerList.add(Collections.singletonList(singleElement));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryList)) {
            return false;
        }
        QueryList other = (QueryList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<T>> this$outerList = this.outerList;
        List<List<T>> other$outerList = other.outerList;
        return !(this$outerList == null ? other$outerList != null : !((Object)this$outerList).equals(other$outerList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<T>> $outerList = this.outerList;
        result = result * 59 + ($outerList == null ? 43 : ((Object)$outerList).hashCode());
        return result;
    }

    public String toString() {
        return "QueryList(outerList=" + this.outerList + ")";
    }

    public List<List<T>> getOuterList() {
        return this.outerList;
    }
}

