/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.responses;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openehealth.ipf.commons.ihe.xds.core.XdsRuntimeException;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ErrorInfo", propOrder={"errorCode", "codeContext", "severity", "location", "customErrorCode"})
public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = 7615868122051414551L;
    private ErrorCode errorCode;
    private String codeContext;
    private Severity severity;
    private String location;
    private String customErrorCode;

    public ErrorInfo() {
    }

    public ErrorInfo(ErrorCode errorCode, String codeContext, Severity severity, String location, String customErrorCode) {
        this.errorCode = errorCode;
        this.codeContext = codeContext;
        this.severity = severity;
        this.location = location;
        this.customErrorCode = customErrorCode;
    }

    public ErrorInfo(Throwable throwable, ErrorCode defaultMetaDataError, ErrorCode defaultError, String defaultLocation) {
        this(defaultError, throwable.getMessage(), Severity.ERROR, defaultLocation, null);
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (t instanceof XDSMetaDataException) {
                XDSMetaDataException metaDataException = (XDSMetaDataException)((Object)t);
                this.errorCode = metaDataException.getValidationMessage().getErrorCode();
                if (this.errorCode == null) {
                    this.errorCode = defaultMetaDataError;
                }
                this.codeContext = metaDataException.getMessage();
                return;
            }
            if (!(t instanceof XdsRuntimeException)) continue;
            XdsRuntimeException exception = (XdsRuntimeException)t;
            this.errorCode = exception.getErrorCode();
            this.codeContext = exception.getCodeContext();
            this.severity = exception.getSeverity();
            this.location = exception.getLocation();
            return;
        }
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getCodeContext() {
        return this.codeContext;
    }

    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getCustomErrorCode() {
        return this.customErrorCode;
    }

    public void setCustomErrorCode(String customErrorCode) {
        this.customErrorCode = customErrorCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codeContext == null ? 0 : this.codeContext.hashCode());
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.customErrorCode == null ? 0 : this.customErrorCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)obj;
        if (this.codeContext == null ? other.codeContext != null : !this.codeContext.equals(other.codeContext)) {
            return false;
        }
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals((Object)other.errorCode)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.severity == null ? other.severity != null : !this.severity.equals((Object)other.severity)) {
            return false;
        }
        return !(this.customErrorCode == null ? other.customErrorCode != null : !this.customErrorCode.equals(other.customErrorCode));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

