/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.responses;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlType(name="Status")
@XmlEnum(value=String.class)
public enum Status {
    FAILURE("Failure", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure"),
    SUCCESS("Success", "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success"),
    PARTIAL_SUCCESS("PartialSuccess", "urn:ihe:iti:2007:ResponseStatusType:PartialSuccess");

    private final String opcode21;
    private final String opcode30;

    private Status(String opcode21, String opcode30) {
        this.opcode21 = opcode21;
        this.opcode30 = opcode30;
    }

    public String getOpcode21() {
        return this.opcode21;
    }

    public String getOpcode30() {
        return this.opcode30;
    }

    public static String getOpcode21(Status status) {
        return status != null ? status.getOpcode21() : null;
    }

    public static String getOpcode30(Status status) {
        return status != null ? status.getOpcode30() : null;
    }

    public static Status valueOfOpcode(String opcode) {
        if (opcode == null) {
            return null;
        }
        for (Status status : Status.values()) {
            if (!opcode.equals(status.getOpcode21()) && !opcode.equals(status.getOpcode30())) continue;
            return status;
        }
        throw new XDSMetaDataException(ValidationMessage.INVALID_STATUS_IN_RESPONSE, new Object[0]);
    }
}

