/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAssociation;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationLabel;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.CodeTransformer;

public class AssociationTransformer {
    private final EbXMLFactory factory;
    private final CodeTransformer codeTransformer;

    public AssociationTransformer(EbXMLFactory factory) {
        Validate.notNull((Object)factory, (String)"factory cannot be null", (Object[])new Object[0]);
        this.factory = factory;
        this.codeTransformer = new CodeTransformer(factory);
    }

    public EbXMLAssociation toEbXML(Association association, EbXMLObjectLibrary objectLibrary) {
        Validate.notNull((Object)objectLibrary, (String)"objectLibrary cannot be null", (Object[])new Object[0]);
        if (association == null) {
            return null;
        }
        EbXMLAssociation result = this.factory.createAssociation(association.getEntryUuid(), objectLibrary);
        result.setAssociationType(association.getAssociationType());
        result.setSource(association.getSourceUuid());
        result.setTarget(association.getTargetUuid());
        String label = AssociationLabel.toOpcode(association.getLabel());
        result.addSlot("SubmissionSetStatus", label);
        String previousVersion = association.getPreviousVersion();
        result.addSlot("PreviousVersion", previousVersion);
        AvailabilityStatus originalStatus = association.getOriginalStatus();
        result.addSlot("OriginalStatus", AvailabilityStatus.toQueryOpcode(originalStatus));
        AvailabilityStatus newStatus = association.getNewStatus();
        result.addSlot("NewStatus", AvailabilityStatus.toQueryOpcode(newStatus));
        result.setAssociationPropagation(association.getAssociationPropagation());
        EbXMLClassification contentType = this.codeTransformer.toEbXML(association.getDocCode(), objectLibrary);
        result.addClassification(contentType, "urn:uuid:abd807a3-4432-4053-87b4-fd82c643d1f3");
        result.setExtraMetadata(association.getExtraMetadata());
        result.setStatus(association.getAvailabilityStatus());
        return result;
    }

    public Association fromEbXML(EbXMLAssociation association) {
        if (association == null) {
            return null;
        }
        Association result = new Association();
        result.setAssociationType(association.getAssociationType());
        result.setTargetUuid(association.getTarget());
        result.setSourceUuid(association.getSource());
        result.setEntryUuid(association.getId());
        String label = association.getSingleSlotValue("SubmissionSetStatus");
        result.setLabel(AssociationLabel.fromOpcode(label));
        String previousVersion = association.getSingleSlotValue("PreviousVersion");
        result.setPreviousVersion(previousVersion);
        String originalStatus = association.getSingleSlotValue("OriginalStatus");
        result.setOriginalStatus(AvailabilityStatus.valueOfOpcode(originalStatus));
        String newStatus = association.getSingleSlotValue("NewStatus");
        result.setNewStatus(AvailabilityStatus.valueOfOpcode(newStatus));
        result.setAssociationPropagation(association.getAssociationPropagation());
        EbXMLClassification docCode = association.getSingleClassification("urn:uuid:abd807a3-4432-4053-87b4-fd82c643d1f3");
        result.setDocCode(this.codeTransformer.fromEbXML(docCode));
        result.setExtraMetadata(association.getExtraMetadata());
        result.setAvailabilityStatus(association.getStatus());
        return result;
    }
}

