/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ExtraMetadataHolder;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XDSMetaClass;

public abstract class XDSMetaClassTransformer<E extends EbXMLRegistryObject, C extends XDSMetaClass> {
    final EbXMLFactory factory;
    private final String patientIdExternalId;
    private final String patientIdLocalizedString;
    private final String uniqueIdExternalId;
    private final String uniqueIdLocalizedString;
    private final String limitedMetadataAttributeName;

    protected XDSMetaClassTransformer(String patientIdExternalId, String patientIdLocalizedString, String uniqueIdExternalId, String uniqueIdLocalizedString, String limitedMetadataAttributeName, EbXMLFactory factory) {
        this.factory = (EbXMLFactory)Validate.notNull((Object)factory, (String)"factory cannot be null", (Object[])new Object[0]);
        this.patientIdExternalId = patientIdExternalId;
        this.patientIdLocalizedString = patientIdLocalizedString;
        this.uniqueIdExternalId = uniqueIdExternalId;
        this.uniqueIdLocalizedString = uniqueIdLocalizedString;
        this.limitedMetadataAttributeName = limitedMetadataAttributeName;
    }

    public E toEbXML(C metaData, EbXMLObjectLibrary objectLibrary) {
        Validate.notNull((Object)objectLibrary, (String)"objectLibrary cannot be null", (Object[])new Object[0]);
        if (metaData == null) {
            return null;
        }
        E ebXML = this.createEbXMLInstance(((XDSMetaClass)metaData).getEntryUuid(), objectLibrary);
        this.addAttributes(metaData, ebXML, objectLibrary);
        this.addClassifications(metaData, ebXML, objectLibrary);
        this.addSlots(metaData, ebXML, objectLibrary);
        this.addExternalIdentifiers(metaData, ebXML, objectLibrary);
        if (ebXML instanceof ExtraMetadataHolder) {
            ((ExtraMetadataHolder)ebXML).setExtraMetadata(((XDSMetaClass)metaData).getExtraMetadata());
        }
        if (((XDSMetaClass)metaData).isLimitedMetadata()) {
            EbXMLClassification classification = this.factory.createClassification(objectLibrary);
            classification.setClassificationNode(this.limitedMetadataAttributeName);
            ebXML.addClassification(classification, this.limitedMetadataAttributeName);
        }
        return ebXML;
    }

    public C fromEbXML(E ebXML) {
        if (ebXML == null) {
            return null;
        }
        C metaData = this.createMetaClassInstance();
        this.addAttributesFromEbXML(metaData, ebXML);
        this.addClassificationsFromEbXML(metaData, ebXML);
        this.addSlotsFromEbXML(metaData, ebXML);
        this.addExternalIdentifiersFromEbXML(metaData, ebXML);
        if (ebXML instanceof ExtraMetadataHolder) {
            ((XDSMetaClass)metaData).setExtraMetadata(((ExtraMetadataHolder)ebXML).getExtraMetadata());
        }
        ((XDSMetaClass)metaData).setLimitedMetadata(ebXML.getClassifications().stream().anyMatch(classification -> this.limitedMetadataAttributeName.equals(classification.getClassificationNode())));
        return metaData;
    }

    protected abstract E createEbXMLInstance(String var1, EbXMLObjectLibrary var2);

    protected abstract C createMetaClassInstance();

    protected void addAttributes(C metaData, E ebXML, EbXMLObjectLibrary objectLibrary) {
        ebXML.setDescription(((XDSMetaClass)metaData).getComments());
        ebXML.setName(((XDSMetaClass)metaData).getTitle());
        ebXML.setLid(((XDSMetaClass)metaData).getLogicalUuid());
        ebXML.setVersionInfo(((XDSMetaClass)metaData).getVersion());
    }

    protected void addAttributesFromEbXML(C metaData, E ebXML) {
        ((XDSMetaClass)metaData).setComments(ebXML.getDescription());
        ((XDSMetaClass)metaData).setTitle(ebXML.getName());
        ((XDSMetaClass)metaData).setEntryUuid(ebXML.getId());
        ((XDSMetaClass)metaData).setLogicalUuid(ebXML.getLid());
        ((XDSMetaClass)metaData).setVersion(ebXML.getVersionInfo());
    }

    protected void addSlots(C metaData, E ebXML, EbXMLObjectLibrary objectLibrary) {
    }

    protected void addSlotsFromEbXML(C metaData, E ebXML) {
    }

    protected void addClassifications(C metaData, E ebXML, EbXMLObjectLibrary objectLibrary) {
    }

    protected void addClassificationsFromEbXML(C metaData, E ebXML) {
    }

    protected void addExternalIdentifiers(C metaData, E ebXML, EbXMLObjectLibrary objectLibrary) {
        String patientID = Hl7v2Based.render(((XDSMetaClass)metaData).getPatientId());
        ebXML.addExternalIdentifier(patientID, this.patientIdExternalId, this.patientIdLocalizedString);
        ebXML.addExternalIdentifier(((XDSMetaClass)metaData).getUniqueId(), this.uniqueIdExternalId, this.uniqueIdLocalizedString);
    }

    protected void addExternalIdentifiersFromEbXML(C metaData, E ebXML) {
        String patientID = ebXML.getExternalIdentifierValue(this.patientIdExternalId);
        ((XDSMetaClass)metaData).setPatientId(Hl7v2Based.parse(patientID, Identifiable.class));
        ((XDSMetaClass)metaData).setUniqueId(ebXML.getExternalIdentifierValue(this.uniqueIdExternalId));
    }
}

