/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.hl7;

import ca.uhn.hl7v2.parser.PipeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.PatientInfo;

public class PatientInfoTransformer {
    public PatientInfo fromHL7(List<String> hl7PID) {
        if (hl7PID == null || hl7PID.isEmpty()) {
            return null;
        }
        PatientInfo patientInfo = new PatientInfo();
        for (String hl7PIDLine : hl7PID) {
            String[] strings;
            String[] fields = PipeParser.split((String)hl7PIDLine.trim(), (String)"|");
            if (fields.length != 2) continue;
            ListIterator<String> iterator = patientInfo.getHl7FieldIterator(fields[0]);
            while (iterator.hasNext()) {
                iterator.next();
            }
            for (String string : strings = PipeParser.split((String)fields[1], (String)"~")) {
                iterator.add(string);
            }
        }
        return patientInfo;
    }

    public List<String> toHL7(PatientInfo patientInfo) {
        if (patientInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        patientInfo.getAllFieldIds().stream().sorted(new PatientInfo.Hl7FieldIdComparator()).forEach(fieldId -> {
            ListIterator<String> iterator = patientInfo.getHl7FieldIterator((String)fieldId);
            String prefix = fieldId + '|';
            StringBuilder sb = new StringBuilder(prefix);
            while (iterator.hasNext()) {
                String repetition = StringUtils.trimToEmpty((String)iterator.next());
                if (repetition.length() > 255 - sb.length() && sb.length() > prefix.length()) {
                    sb.setLength(sb.length() - 1);
                    result.add(sb.toString());
                    sb.setLength(prefix.length());
                }
                sb.append(repetition).append('~');
            }
            if (sb.length() > prefix.length() + 1) {
                sb.setLength(sb.length() - 1);
                result.add(sb.toString());
            }
        });
        return result;
    }
}

