/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.DocumentsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

abstract class DocumentsQueryTransformer<T extends DocumentsQuery>
extends AbstractStoredQueryTransformer<T> {
    DocumentsQueryTransformer() {
    }

    @Override
    public void toEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromStringList(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, ((DocumentsQuery)query).getAuthorPersons());
        slots.fromNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, Timestamp.toHL7(((DocumentsQuery)query).getCreationTime().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, Timestamp.toHL7(((DocumentsQuery)query).getCreationTime().getTo()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, Timestamp.toHL7(((DocumentsQuery)query).getServiceStartTime().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, Timestamp.toHL7(((DocumentsQuery)query).getServiceStartTime().getTo()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, Timestamp.toHL7(((DocumentsQuery)query).getServiceStopTime().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, Timestamp.toHL7(((DocumentsQuery)query).getServiceStopTime().getTo()));
        slots.fromCode(QueryParameter.DOC_ENTRY_FORMAT_CODE, ((DocumentsQuery)query).getFormatCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_CLASS_CODE, ((DocumentsQuery)query).getClassCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_TYPE_CODE, ((DocumentsQuery)query).getTypeCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE, ((DocumentsQuery)query).getHealthcareFacilityTypeCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE, ((DocumentsQuery)query).getPracticeSettingCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_EVENT_CODE, ((DocumentsQuery)query).getEventCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, ((DocumentsQuery)query).getConfidentialityCodes());
    }

    @Override
    public void fromEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        ((DocumentsQuery)query).setClassCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_CLASS_CODE));
        ((DocumentsQuery)query).setTypeCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_TYPE_CODE));
        ((DocumentsQuery)query).setPracticeSettingCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE));
        ((DocumentsQuery)query).setHealthcareFacilityTypeCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE));
        ((DocumentsQuery)query).setFormatCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_FORMAT_CODE));
        ((DocumentsQuery)query).setEventCodes(slots.toCodeQueryList(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME));
        ((DocumentsQuery)query).setConfidentialityCodes(slots.toCodeQueryList(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME));
        ((DocumentsQuery)query).setAuthorPersons(slots.toStringList(QueryParameter.DOC_ENTRY_AUTHOR_PERSON));
        ((DocumentsQuery)query).getCreationTime().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM));
        ((DocumentsQuery)query).getCreationTime().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_TO));
        ((DocumentsQuery)query).getServiceStartTime().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM));
        ((DocumentsQuery)query).getServiceStartTime().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO));
        ((DocumentsQuery)query).getServiceStopTime().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM));
        ((DocumentsQuery)query).getServiceStopTime().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO));
    }
}

